package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@ApiModel(description = "修改发票匹配的业务单号")
@JsonInclude(NON_NULL)
public class ModifyInvoiceSalesRequest {

    @JsonProperty("salesbillId")
    private String salesbillId;//业务单id
    @JsonProperty("salesbillNo")
    private String salesbillNo;//业务单编号
    @JsonProperty("matchStatus")
    private String matchStatus;//1-已匹配，非1-取消匹配
    @JsonProperty("invoiceIds")
    private List<Long> invoiceIds = null;//发票集合

    @ApiModelProperty(value = "业务单id")
    public String getSalesbillId() {
        return salesbillId;
    }

    public void setSalesbillId(String salesbillId) {
        this.salesbillId = salesbillId;
    }

    @ApiModelProperty(value = "业务单编号")
    public String getSalesbillNo() {
        return salesbillNo;
    }

    public void setSalesbillNo(String salesbillNo) {
        this.salesbillNo = salesbillNo;
    }

    @ApiModelProperty(value = "匹配状态")
    public String getMatchStatus() {
        return matchStatus;
    }

    public void setMatchStatus(String matchStatus) {
        this.matchStatus = matchStatus;
    }

    @ApiModelProperty(value = "发票id集合")
    public List<Long> getInvoiceIds() {
        return invoiceIds;
    }

    public void setInvoiceIds(List<Long> invoiceIds) {
        this.invoiceIds = invoiceIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ModifyInvoiceSalesRequest that = (ModifyInvoiceSalesRequest) o;
        return Objects.equals(salesbillId, that.salesbillId) &&
                Objects.equals(salesbillNo, that.salesbillNo) &&
                Objects.equals(matchStatus, that.matchStatus) &&
                Objects.equals(invoiceIds, that.invoiceIds);
    }

    @Override
    public int hashCode() {

        return Objects.hash(salesbillId, salesbillNo, matchStatus, invoiceIds);
    }

    @Override
    public String toString() {
        return "ModifyInvoiceSalesRequest{" +
                "salesbillId='" + salesbillId + '\'' +
                ", salesbillNo='" + salesbillNo + '\'' +
                ", matchStatus='" + matchStatus + '\'' +
                ", invoiceIds=" + invoiceIds +
                '}';
    }
}
