package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * MsGetApplyResultResponseResultResultInfo
 */

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetApplyResultResponseResultResultInfo {
  @JsonProperty("applyDate")
  private String applyDate = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("pid")
  private String pid = null;

  @JsonProperty("processFlag")
  private String processFlag = null;

  @JsonProperty("processRemark")
  private String processRemark = null;

  @JsonProperty("redNotificationNo")
  private String redNotificationNo = null;

  @JsonProperty("requestBillNo")
  private String requestBillNo = null;

  @JsonIgnore
  public MsGetApplyResultResponseResultResultInfo applyDate(String applyDate) {
    this.applyDate = applyDate;
    return this;
  }

   /**
   * return applyDate
   * @return applyDate
  **/
  @ApiModelProperty(value = "return applyDate")
  public String getApplyDate() {
    return applyDate;
  }

  public void setApplyDate(String applyDate) {
    this.applyDate = applyDate;
  }

  @JsonIgnore
  public MsGetApplyResultResponseResultResultInfo machineCode(String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * return machineCode
   * @return machineCode
  **/
  @ApiModelProperty(value = "return machineCode")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public MsGetApplyResultResponseResultResultInfo pid(String pid) {
    this.pid = pid;
    return this;
  }

   /**
   * return pid
   * @return pid
  **/
  @ApiModelProperty(value = "return pid")
  public String getPid() {
    return pid;
  }

  public void setPid(String pid) {
    this.pid = pid;
  }

  @JsonIgnore
  public MsGetApplyResultResponseResultResultInfo processFlag(String processFlag) {
    this.processFlag = processFlag;
    return this;
  }

   /**
   * return processFlag
   * @return processFlag
  **/
  @ApiModelProperty(value = "return processFlag")
  public String getProcessFlag() {
    return processFlag;
  }

  public void setProcessFlag(String processFlag) {
    this.processFlag = processFlag;
  }

  @JsonIgnore
  public MsGetApplyResultResponseResultResultInfo processRemark(String processRemark) {
    this.processRemark = processRemark;
    return this;
  }

   /**
   * return processRemark
   * @return processRemark
  **/
  @ApiModelProperty(value = "return processRemark")
  public String getProcessRemark() {
    return processRemark;
  }

  public void setProcessRemark(String processRemark) {
    this.processRemark = processRemark;
  }

  @JsonIgnore
  public MsGetApplyResultResponseResultResultInfo redNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
    return this;
  }

   /**
   * return redNotificationNo
   * @return redNotificationNo
  **/
  @ApiModelProperty(value = "return redNotificationNo")
  public String getRedNotificationNo() {
    return redNotificationNo;
  }

  public void setRedNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
  }

  @JsonIgnore
  public MsGetApplyResultResponseResultResultInfo requestBillNo(String requestBillNo) {
    this.requestBillNo = requestBillNo;
    return this;
  }

   /**
   * return requestBillNo
   * @return requestBillNo
  **/
  @ApiModelProperty(value = "return requestBillNo")
  public String getRequestBillNo() {
    return requestBillNo;
  }

  public void setRequestBillNo(String requestBillNo) {
    this.requestBillNo = requestBillNo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetApplyResultResponseResultResultInfo getApplyResultResponseResultResultInfo = (MsGetApplyResultResponseResultResultInfo) o;
    return Objects.equals(this.applyDate, getApplyResultResponseResultResultInfo.applyDate) &&
        Objects.equals(this.machineCode, getApplyResultResponseResultResultInfo.machineCode) &&
        Objects.equals(this.pid, getApplyResultResponseResultResultInfo.pid) &&
        Objects.equals(this.processFlag, getApplyResultResponseResultResultInfo.processFlag) &&
        Objects.equals(this.processRemark, getApplyResultResponseResultResultInfo.processRemark) &&
        Objects.equals(this.redNotificationNo, getApplyResultResponseResultResultInfo.redNotificationNo) &&
        Objects.equals(this.requestBillNo, getApplyResultResponseResultResultInfo.requestBillNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(applyDate, machineCode, pid, processFlag, processRemark, redNotificationNo, requestBillNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetApplyResultResponseResultResultInfo {\n");

    sb.append("    applyDate: ").append(toIndentedString(applyDate)).append("\n");
    sb.append("    machineCode: ").append(toIndentedString(machineCode)).append("\n");
    sb.append("    pid: ").append(toIndentedString(pid)).append("\n");
    sb.append("    processFlag: ").append(toIndentedString(processFlag)).append("\n");
    sb.append("    processRemark: ").append(toIndentedString(processRemark)).append("\n");
    sb.append("    redNotificationNo: ").append(toIndentedString(redNotificationNo)).append("\n");
    sb.append("    requestBillNo: ").append(toIndentedString(requestBillNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
