package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysRedNoNumberDto {
  @JsonProperty("total")
  private Long total = null;

  @JsonProperty("confirming")
  private Long confirming = null;

  @JsonProperty("applicationPending")
  private Long applicationPending = null;

  @JsonProperty("applying")
  private Long applying = null;

  @JsonProperty("applied")
  private Long applied = null;

  @JsonIgnore
  public MsSysRedNoNumberDto total(Long total) {
    this.total = total;
    return this;
  }

   /**
   * 合计
   * @return total
  **/
  @ApiModelProperty(value = "合计")
  public Long getTotal() {
    return total;
  }

  public void setTotal(Long total) {
    this.total = total;
  }

  @JsonIgnore
  public MsSysRedNoNumberDto confirming(Long confirming) {
    this.confirming = confirming;
    return this;
  }

   /**
   * 待审核
   * @return confirming
  **/
  @ApiModelProperty(value = "待审核")
  public Long getConfirming() {
    return confirming;
  }

  public void setConfirming(Long confirming) {
    this.confirming = confirming;
  }

  @JsonIgnore
  public MsSysRedNoNumberDto applicationPending(Long applicationPending) {
    this.applicationPending = applicationPending;
    return this;
  }

   /**
   * 待申请
   * @return applicationPending
  **/
  @ApiModelProperty(value = "待申请")
  public Long getApplicationPending() {
    return applicationPending;
  }

  public void setApplicationPending(Long applicationPending) {
    this.applicationPending = applicationPending;
  }

  @JsonIgnore
  public MsSysRedNoNumberDto applying(Long applying) {
    this.applying = applying;
    return this;
  }

   /**
   * 申请中
   * @return applying
  **/
  @ApiModelProperty(value = "申请中")
  public Long getApplying() {
    return applying;
  }

  public void setApplying(Long applying) {
    this.applying = applying;
  }

  @JsonIgnore
  public MsSysRedNoNumberDto applied(Long applied) {
    this.applied = applied;
    return this;
  }

   /**
   * 已申请
   * @return applied
  **/
  @ApiModelProperty(value = "已申请")
  public Long getApplied() {
    return applied;
  }

  public void setApplied(Long applied) {
    this.applied = applied;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysRedNoNumberDto sysRedNoNumberDto = (MsSysRedNoNumberDto) o;
    return Objects.equals(this.total, sysRedNoNumberDto.total) &&
        Objects.equals(this.confirming, sysRedNoNumberDto.confirming) &&
        Objects.equals(this.applicationPending, sysRedNoNumberDto.applicationPending) &&
        Objects.equals(this.applying, sysRedNoNumberDto.applying) &&
        Objects.equals(this.applied, sysRedNoNumberDto.applied);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total, confirming, applicationPending, applying, applied);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysRedNoNumberDto {\n");

    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    confirming: ").append(toIndentedString(confirming)).append("\n");
    sb.append("    applicationPending: ").append(toIndentedString(applicationPending)).append("\n");
    sb.append("    applying: ").append(toIndentedString(applying)).append("\n");
    sb.append("    applied: ").append(toIndentedString(applied)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
