package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * SplitInvoiceRequest
 */

@JsonInclude(NON_NULL)
public class QueryInvoicesBySaleItemIdsRequest {

    @JsonProperty("saleItemIds")
    private List<Long> saleItemIds = null;

    @ApiModelProperty(value = "业务单明细id列表")
    public List<Long> getSaleItemIds() {
        return saleItemIds;
    }

    public void setSaleItemIds(List<Long> saleItemIds) {
        this.saleItemIds = saleItemIds;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((saleItemIds == null) ? 0 : saleItemIds.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        QueryInvoicesBySaleItemIdsRequest other = (QueryInvoicesBySaleItemIdsRequest) obj;
        if (saleItemIds == null) {
            if (other.saleItemIds != null)
                return false;
        } else if (!saleItemIds.equals(other.saleItemIds))
            return false;
        return true;
    }

}
