package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 红冲校验接口结果
 */
@ApiModel(description = "红冲校验接口结果")

@JsonInclude(NON_NULL)
public class RedflushInvoiceCheckResult {


    public InvSellerRedNotificationLogDto getInvSellerRedNotificationLogDto() {
        return invSellerRedNotificationLogDto;
    }

    public void setInvSellerRedNotificationLogDto(InvSellerRedNotificationLogDto invSellerRedNotificationLogDto) {
        this.invSellerRedNotificationLogDto = invSellerRedNotificationLogDto;
    }

    @ApiModelProperty(value = "查询红字信息表申请结果")
    @JsonProperty("redflushInvoiceCheckResult")
    private InvSellerRedNotificationLogDto invSellerRedNotificationLogDto;

    @ApiModelProperty(value = "校验结果 0-校验失败 1-校验成功")
    @JsonProperty("checked")
    private Integer checked;

    @ApiModelProperty(value = "校验结果失败信息")
    @JsonProperty("message")
    private String message ;

    @ApiModelProperty(value = "释放类型系统配置 0-未配置 1-配置")
    @JsonProperty("isConfig")
    private Integer isConfig ;

    @ApiModelProperty(value = "释放类型系统配置值")
    @JsonProperty("configValue")
    private String configValue ;

    @ApiModelProperty(value = "可红冲发票id列表")
    @JsonProperty("invoiceIds")
    private List<String> invoiceIds;

    @ApiModelProperty(value = "含税总金额")
    @JsonProperty("totalAmountWithTax")
    private BigDecimal totalAmountWithTax ;

    @ApiModelProperty(value = "不含税总金额")
    @JsonProperty("totalAmountWithOutTax")
    private BigDecimal totalAmountWithOutTax ;


    @ApiModelProperty(value = "税额")
    @JsonProperty("taxAmount")
    private BigDecimal taxAmount ;

    @ApiModelProperty(value = "发票号码")
    @JsonProperty("invoiceNo")
    private String invoiceNo ;

    @ApiModelProperty(value = "发票代码")
    @JsonProperty("invoiceCode")
    private String invoiceCode ;

    @ApiModelProperty(value = "销方公司")
    @JsonProperty("componyName")
    private String componyName ;


    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }


    public Integer getChecked() {
        return checked;
    }

    public void setChecked(Integer checked) {
        this.checked = checked;
    }

    public Integer getIsConfig() {
        return isConfig;
    }

    public void setIsConfig(Integer isConfig) {
        this.isConfig = isConfig;
    }

    public String getConfigValue() {
        return configValue;
    }

    public void setConfigValue(String configValue) {
        this.configValue = configValue;
    }

    public List<String> getInvoiceIds() {
        return invoiceIds;
    }

    public void setInvoiceIds(List<String> invoiceIds) {
        this.invoiceIds = invoiceIds;
    }

    public BigDecimal getTotalAmountWithTax() {
        return totalAmountWithTax;
    }

    public void setTotalAmountWithTax(BigDecimal totalAmountWithTax) {
        this.totalAmountWithTax = totalAmountWithTax;
    }

    public BigDecimal getTotalAmountWithOutTax() {
        return totalAmountWithOutTax;
    }

    public void setTotalAmountWithOutTax(BigDecimal totalAmountWithOutTax) {
        this.totalAmountWithOutTax = totalAmountWithOutTax;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public String getComponyName() {
        return componyName;
    }

    public void setComponyName(String componyName) {
        this.componyName = componyName;
    }
}
