package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * RedflushSellerInvoiceCheckRequest
 */

@JsonInclude(NON_NULL)
public class RedflushSellerInvoiceCheckRequest {
    @JsonProperty("conditions")
    private Conditions conditions = null;

  @JsonProperty("isAllSelected")
  private Boolean isAllSelected = null;

  @JsonProperty("includes")
  private List<Long> includes = new ArrayList<Long>();

  @JsonProperty("excludes")
  private List<Long> excludes = new ArrayList<Long>();

  @JsonProperty("deviceId")
  private Long deviceId = null;

  @JsonProperty("mip")
  private String mip = null;

  @JsonProperty("mode")
  private String mode = null;

  @JsonProperty("nextInvoiceNo")
  private String nextInvoiceNo = null;

  @JsonProperty("nextInvoiceCode")
  private String nextInvoiceCode = null;

  @JsonProperty("invoicerName")
  private String invoicerName = null;

  @JsonProperty("tenantNo")
  private String tenantNo = null;

  @JsonProperty("companyId")
  private String companyId = null;

  @JsonProperty("redNotificationNo")
  private String redNotificationNo = null;

  @JsonProperty("redFlushModel")
  private Integer redFlushModel = null;

  @JsonProperty("reason")
  private String reason = null;

  @JsonIgnore
  public RedflushSellerInvoiceCheckRequest coditions(Conditions coditions) {
      this.conditions = coditions;
    return this;
  }

  /**
   * Get conditions
   * @return conditions
   **/
  @ApiModelProperty(value = "")
  public Conditions getConditions() {
      return conditions;
  }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
  }

  @JsonIgnore
  public RedflushSellerInvoiceCheckRequest isAllSelected(Boolean isAllSelected) {
    this.isAllSelected = isAllSelected;
    return this;
  }

  /**
   * 是否全选：true-全选 false-非全选
   * @return isAllSelected
   **/
  @ApiModelProperty(value = "是否全选：true-全选 false-非全选")
  public Boolean getIsAllSelected() {
    return isAllSelected;
  }

  public void setIsAllSelected(Boolean isAllSelected) {
    this.isAllSelected = isAllSelected;
  }

  @JsonIgnore
  public RedflushSellerInvoiceCheckRequest includes(List<Long> includes) {
    this.includes = includes;
    return this;
  }

  public RedflushSellerInvoiceCheckRequest addIncludesItem(Long includesItem) {
    this.includes.add(includesItem);
    return this;
  }

  /**
   * 包含项-发票序列号主键列表
   * @return includes
   **/
  @ApiModelProperty(value = "包含项-发票序列号主键列表")
  public List<Long> getIncludes() {
    return includes;
  }

  public void setIncludes(List<Long> includes) {
    this.includes = includes;
  }

  @JsonIgnore
  public RedflushSellerInvoiceCheckRequest excludes(List<Long> excludes) {
    this.excludes = excludes;
    return this;
  }

  public RedflushSellerInvoiceCheckRequest addExcludesItem(Long excludesItem) {
    this.excludes.add(excludesItem);
    return this;
  }

  /**
   * 排除项-发票序列号主键列表
   * @return excludes
   **/
  @ApiModelProperty(value = "排除项-发票序列号主键列表")
  public List<Long> getExcludes() {
    return excludes;
  }

  public void setExcludes(List<Long> excludes) {
    this.excludes = excludes;
  }

  @JsonIgnore
  public RedflushSellerInvoiceCheckRequest deviceId(Long deviceId) {
    this.deviceId = deviceId;
    return this;
  }

  /**
   * 开票设备ID
   * @return deviceId
   **/
  @ApiModelProperty(value = "开票设备ID")
  public Long getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(Long deviceId) {
    this.deviceId = deviceId;
  }

  @JsonIgnore
  public RedflushSellerInvoiceCheckRequest mip(String mip) {
    this.mip = mip;
    return this;
  }

  /**
   * Get mip
   * @return mip
   **/
  @ApiModelProperty(value = "")
  public String getMip() {
    return mip;
  }

  public void setMip(String mip) {
    this.mip = mip;
  }

  @JsonIgnore
  public RedflushSellerInvoiceCheckRequest mode(String mode) {
    this.mode = mode;
    return this;
  }

  /**
   * Get mode
   * @return mode
   **/
  @ApiModelProperty(value = "")
  public String getMode() {
    return mode;
  }

  public void setMode(String mode) {
    this.mode = mode;
  }

  @JsonIgnore
  public RedflushSellerInvoiceCheckRequest nextInvoiceNo(String nextInvoiceNo) {
    this.nextInvoiceNo = nextInvoiceNo;
    return this;
  }

  /**
   * 下一张发票号码
   * @return nextInvoiceNo
   **/
  @ApiModelProperty(value = "下一张发票号码")
  public String getNextInvoiceNo() {
    return nextInvoiceNo;
  }

  public void setNextInvoiceNo(String nextInvoiceNo) {
    this.nextInvoiceNo = nextInvoiceNo;
  }

  @JsonIgnore
  public RedflushSellerInvoiceCheckRequest nextInvoiceCode(String nextInvoiceCode) {
    this.nextInvoiceCode = nextInvoiceCode;
    return this;
  }

  /**
   * 下一张发票代码
   * @return nextInvoiceCode
   **/
  @ApiModelProperty(value = "下一张发票代码")
  public String getNextInvoiceCode() {
    return nextInvoiceCode;
  }

  public void setNextInvoiceCode(String nextInvoiceCode) {
    this.nextInvoiceCode = nextInvoiceCode;
  }

  @JsonIgnore
  public RedflushSellerInvoiceCheckRequest invoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
    return this;
  }

  /**
   * 开票人
   * @return invoicerName
   **/
  @ApiModelProperty(value = "开票人")
  public String getInvoicerName() {
    return invoicerName;
  }

  public void setInvoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
  }

  @JsonIgnore
  public RedflushSellerInvoiceCheckRequest tenantNo(String tenantNo) {
    this.tenantNo = tenantNo;
    return this;
  }

  /**
   * 集团代码
   * @return tenantNo
   **/
  @ApiModelProperty(value = "集团代码")
  public String getTenantNo() {
    return tenantNo;
  }

  public void setTenantNo(String tenantNo) {
    this.tenantNo = tenantNo;
  }

  @JsonIgnore
  public RedflushSellerInvoiceCheckRequest companyId(String companyId) {
    this.companyId = companyId;
    return this;
  }

  /**
   * 公司id
   * @return companyId
   **/
  @ApiModelProperty(value = "公司id")
  public String getCompanyId() {
    return companyId;
  }

  public void setCompanyId(String companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public RedflushSellerInvoiceCheckRequest redFlushModel(Integer redFlushModel) {
    this.redFlushModel = redFlushModel;
    return this;
  }

  /**
   * 红冲模式1-红冲后可对预制发票再次开具 2-红冲后可对业务单明细选择并开具 3-红冲后无法再次开具
   * @return redFlushModel
   **/
  @ApiModelProperty(value = "红冲模式1-红冲后可对预制发票再次开具 2-红冲后可对业务单明细选择并开具 3-红冲后无法再次开具")
  public Integer getRedFlushModel() {
    return redFlushModel;
  }

  public void setRedFlushModel(Integer redFlushModel) {
    this.redFlushModel = redFlushModel;
  }

  @JsonIgnore
  public RedflushSellerInvoiceCheckRequest reason(String reason) {
    this.reason = reason;
    return this;
  }

  /**
   * 红冲原因
   * @return reason
   **/
  @ApiModelProperty(value = "红冲原因")
  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }


  /**
   * 红字信息编号
   * @return redNotificationNo
   **/
  @ApiModelProperty(value = "红字信息编号 ")
  public String getRedNotificationNo() {
    return redNotificationNo;
  }

  public void setRedNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RedflushSellerInvoiceCheckRequest redflushSellerInvoiceCheckRequest = (RedflushSellerInvoiceCheckRequest) o;
      return Objects.equals(this.conditions, redflushSellerInvoiceCheckRequest.conditions) &&
            Objects.equals(this.isAllSelected, redflushSellerInvoiceCheckRequest.isAllSelected) &&
            Objects.equals(this.includes, redflushSellerInvoiceCheckRequest.includes) &&
            Objects.equals(this.excludes, redflushSellerInvoiceCheckRequest.excludes) &&
            Objects.equals(this.deviceId, redflushSellerInvoiceCheckRequest.deviceId) &&
            Objects.equals(this.mip, redflushSellerInvoiceCheckRequest.mip) &&
            Objects.equals(this.mode, redflushSellerInvoiceCheckRequest.mode) &&
            Objects.equals(this.nextInvoiceNo, redflushSellerInvoiceCheckRequest.nextInvoiceNo) &&
            Objects.equals(this.nextInvoiceCode, redflushSellerInvoiceCheckRequest.nextInvoiceCode) &&
            Objects.equals(this.invoicerName, redflushSellerInvoiceCheckRequest.invoicerName) &&
            Objects.equals(this.tenantNo, redflushSellerInvoiceCheckRequest.tenantNo) &&
            Objects.equals(this.companyId, redflushSellerInvoiceCheckRequest.companyId) &&
            Objects.equals(this.redFlushModel, redflushSellerInvoiceCheckRequest.redFlushModel) &&
            Objects.equals(this.redNotificationNo, redflushSellerInvoiceCheckRequest.redNotificationNo) &&
            Objects.equals(this.reason, redflushSellerInvoiceCheckRequest.reason);
  }

  @Override
  public int hashCode() {
      return Objects.hash(conditions, isAllSelected, includes, excludes, deviceId, mip, mode, nextInvoiceNo, nextInvoiceCode, invoicerName, tenantNo, companyId, redNotificationNo, redFlushModel, reason);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RedflushSellerInvoiceCheckRequest {\n");

      sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
    sb.append("    isAllSelected: ").append(toIndentedString(isAllSelected)).append("\n");
    sb.append("    includes: ").append(toIndentedString(includes)).append("\n");
    sb.append("    excludes: ").append(toIndentedString(excludes)).append("\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    mip: ").append(toIndentedString(mip)).append("\n");
    sb.append("    mode: ").append(toIndentedString(mode)).append("\n");
    sb.append("    nextInvoiceNo: ").append(toIndentedString(nextInvoiceNo)).append("\n");
    sb.append("    nextInvoiceCode: ").append(toIndentedString(nextInvoiceCode)).append("\n");
    sb.append("    invoicerName: ").append(toIndentedString(invoicerName)).append("\n");
    sb.append("    tenantNo: ").append(toIndentedString(tenantNo)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    redFlushModel: ").append(toIndentedString(redFlushModel)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
