package com.xforceplus.seller.invoice.client.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制发票信息
 */
@ApiModel(description = "预制发票信息")

@JsonInclude(NON_NULL)
public class SellerPreInvoice {
    @JsonProperty("id")
    @JSONField(serializeUsing = ToStringSerializer.class)
    private Long id = null;

    @JsonProperty("salesbillNo")
    private String salesbillNo = null;

    @JsonProperty("batchNo")
    @JSONField(serializeUsing = ToStringSerializer.class)
    private Long batchNo = null;

    @ApiModelProperty("外部批次号")
    @JSONField(serializeUsing = ToStringSerializer.class)
    private Long outBatchNo;

    @JsonProperty("sellerTenantId")
    private String sellerTenantId = null;

    @JsonProperty("sellerNo")
    private String sellerNo = null;

    @JsonProperty("sellerCode")
    private String sellerCode = null;

    @JsonProperty("sellerName")
    private String sellerName = null;

    @JsonProperty("sellerTaxNo")
    private String sellerTaxNo = null;

    @JsonProperty("sellerTel")
    private String sellerTel = null;

    @JsonProperty("sellerAddress")
    private String sellerAddress = null;

    @JsonProperty("sellerBankName")
    private String sellerBankName = null;

    @JsonProperty("sellerBankAccount")
    private String sellerBankAccount = null;

    @JsonProperty("purchaserName")
    private String purchaserName = null;

    @JsonProperty("purchaserTenantId")
    private String purchaserTenantId = null;

    @JsonProperty("purchaserId")
    private String purchaserId = null;

    @JsonProperty("purchaserNo")
    private String purchaserNo = null;

    @JsonProperty("purchaserTaxNo")
    private String purchaserTaxNo = null;

    @JsonProperty("purchaserTel")
    private String purchaserTel = null;

    @JsonProperty("purchaserAddress")
    private String purchaserAddress = null;

    @JsonProperty("purchaserBankName")
    private String purchaserBankName = null;

    @JsonProperty("purchaserBankAccount")
    private String purchaserBankAccount = null;

    @JsonProperty("invoiceType")
    private String invoiceType = null;

    @JsonProperty("businessBillType")
    private String businessBillType = null;

    @JsonProperty("salesbillType")
    private String salesbillType = null;

    @JsonProperty("invoiceCode")
    private String invoiceCode = null;

    @JsonProperty("invoiceNo")
    private String invoiceNo = null;

    @JsonProperty("machineCode")
    private String machineCode = null;

    @JsonProperty("paperDrawDate")
    private String paperDrawDate = null;

    @JsonProperty("checkCode")
    private String checkCode = null;

    @JsonProperty("cashierName")
    private String cashierName = null;

    @JsonProperty("checkerName")
    private String checkerName = null;

    @JsonProperty("invoicerName")
    private String invoicerName = null;

    @JsonProperty("remark")
    private String remark = null;

    @JsonProperty("electronicSignature")
    private String electronicSignature = null;

    @JsonProperty("amountWithTax")
    private BigDecimal amountWithTax = null;

    @JsonProperty("amountWithoutTax")
    private BigDecimal amountWithoutTax = null;

    @JsonProperty("taxAmount")
    private BigDecimal taxAmount = null;

    @JsonProperty("cipherText")
    private String cipherText = null;

    @JsonProperty("cipherTextTwoCode")
    private String cipherTextTwoCode = null;

    @JsonProperty("lockFlag")
    private Integer lockFlag = null;

    @JsonProperty("status")
    private Integer status = null;

    @JsonProperty("createTime")
    private Date createTime = null;

    @JsonProperty("createUserId")
    private String createUserId = null;

    @JsonProperty("updateTime")
    private Date updateTime = null;

    @JsonProperty("updateUserId")
    private String updateUserId = null;

    @JsonProperty("ext1")
    private String ext1 = null;

    @JsonProperty("ext2")
    private String ext2 = null;

    @JsonProperty("ext3")
    private String ext3 = null;

    @JsonProperty("ext4")
    private String ext4 = null;

    @JsonProperty("ext5")
    private String ext5 = null;

    @JsonProperty("ext6")
    private String ext6 = null;

    @JsonProperty("ext7")
    private String ext7 = null;

    @JsonProperty("ext8")
    private String ext8 = null;

    @JsonProperty("ext9")
    private String ext9 = null;

    @JsonProperty("ext10")
    private String ext10 = null;

    @JsonProperty("ext11")
    private String ext11 = null;

    @JsonProperty("ext12")
    private String ext12 = null;

    @JsonProperty("ext13")
    private String ext13 = null;

    @JsonProperty("ext14")
    private String ext14 = null;

    @JsonProperty("ext15")
    private String ext15 = null;

    @JsonProperty("ext16")
    private String ext16 = null;

    @JsonProperty("ext17")
    private String ext17 = null;

    @JsonProperty("ext18")
    private String ext18 = null;

    @JsonProperty("ext19")
    private String ext19 = null;

    @JsonProperty("ext20")
    private String ext20 = null;

    @JsonProperty("ext21")
    private String ext21 = null;

    @JsonProperty("ext22")
    private String ext22 = null;

    @JsonProperty("ext23")
    private String ext23 = null;

    @JsonProperty("ext24")
    private String ext24 = null;

    @JsonProperty("ext25")
    private String ext25 = null;

    @ApiModelProperty(value = "规则id")
    private Long ruleId;

    @JsonProperty("originInvoiceNo")
    private String originInvoiceNo = null;

    @JsonProperty("originInvoiceCode")
    private String originInvoiceCode = null;

    @JsonProperty("redNotificationNo")
    private String redNotificationNo = null;

    @JsonIgnore
    public SellerPreInvoice id(Long id) {
        this.id = id;
        return this;
    }

    /**
     * 预制发票id
     *
     * @return id
     **/
    @ApiModelProperty(value = "预制发票id")
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public SellerPreInvoice salesbillNo(String salesbillNo) {
        this.salesbillNo = salesbillNo;
        return this;
    }

    /**
     * 预制发票id
     *
     * @return id
     **/
    @ApiModelProperty(value = "单据编号")
    public String getSalesbillNo() {
        return salesbillNo;
    }

    public void setSalesbillNo(String salesbillNo) {
        this.salesbillNo = salesbillNo;
    }

    @JsonIgnore
    public SellerPreInvoice batchNo(Long batchNo) {
        this.batchNo = batchNo;
        return this;
    }

    /**
     * 批次号
     *
     * @return batchNo
     **/
    @ApiModelProperty(value = "批次号")
    public Long getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(Long batchNo) {
        this.batchNo = batchNo;
    }

    @JsonIgnore
    public SellerPreInvoice sellerTenantId(String sellerTenantId) {
        this.sellerTenantId = sellerTenantId;
        return this;
    }

    /**
     * 销方租户id
     *
     * @return sellerTenantId
     **/
    @ApiModelProperty(value = "销方租户id")
    public String getSellerTenantId() {
        return sellerTenantId;
    }

    public void setSellerTenantId(String sellerTenantId) {
        this.sellerTenantId = sellerTenantId;
    }

    @JsonIgnore
    public SellerPreInvoice sellerNo(String sellerNo) {
        this.sellerNo = sellerNo;
        return this;
    }

    /**
     * 销方租户公司编号
     *
     * @return sellerNo
     **/
    @ApiModelProperty(value = "销方租户公司编号")
    public String getSellerNo() {
        return sellerNo;
    }

    public void setSellerNo(String sellerNo) {
        this.sellerNo = sellerNo;
    }

    @JsonIgnore
    public SellerPreInvoice sellerCode(String sellerCode) {
        this.sellerCode = sellerCode;
        return this;
    }

    /**
     * 销方公司代码
     *
     * @return sellerCode
     **/
    @ApiModelProperty(value = "销方公司代码")
    public String getSellerCode() {
        return sellerCode;
    }

    public void setSellerCode(String sellerCode) {
        this.sellerCode = sellerCode;
    }

    @JsonIgnore
    public SellerPreInvoice sellerName(String sellerName) {
        this.sellerName = sellerName;
        return this;
    }

    /**
     * 销方名称
     *
     * @return sellerName
     **/
    @ApiModelProperty(value = "销方名称")
    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    @JsonIgnore
    public SellerPreInvoice sellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
        return this;
    }

    /**
     * 销方纳税人识别号
     *
     * @return sellerTaxNo
     **/
    @ApiModelProperty(value = "销方纳税人识别号")
    public String getSellerTaxNo() {
        return sellerTaxNo;
    }

    public void setSellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
    }

    @JsonIgnore
    public SellerPreInvoice sellerTel(String sellerTel) {
        this.sellerTel = sellerTel;
        return this;
    }

    /**
     * 销方电话
     *
     * @return sellerTel
     **/
    @ApiModelProperty(value = "销方电话")
    public String getSellerTel() {
        return sellerTel;
    }

    public void setSellerTel(String sellerTel) {
        this.sellerTel = sellerTel;
    }

    @JsonIgnore
    public SellerPreInvoice sellerAddress(String sellerAddress) {
        this.sellerAddress = sellerAddress;
        return this;
    }

    /**
     * 销方地址
     *
     * @return sellerAddress
     **/
    @ApiModelProperty(value = "销方地址")
    public String getSellerAddress() {
        return sellerAddress;
    }

    public void setSellerAddress(String sellerAddress) {
        this.sellerAddress = sellerAddress;
    }

    @JsonIgnore
    public SellerPreInvoice sellerBankName(String sellerBankName) {
        this.sellerBankName = sellerBankName;
        return this;
    }

    /**
     * 销方银行名称
     *
     * @return sellerBankName
     **/
    @ApiModelProperty(value = "销方银行名称")
    public String getSellerBankName() {
        return sellerBankName;
    }

    public void setSellerBankName(String sellerBankName) {
        this.sellerBankName = sellerBankName;
    }

    @JsonIgnore
    public SellerPreInvoice sellerBankAccount(String sellerBankAccount) {
        this.sellerBankAccount = sellerBankAccount;
        return this;
    }

    /**
     * 销方银行账号
     *
     * @return sellerBankAccount
     **/
    @ApiModelProperty(value = "销方银行账号")
    public String getSellerBankAccount() {
        return sellerBankAccount;
    }

    public void setSellerBankAccount(String sellerBankAccount) {
        this.sellerBankAccount = sellerBankAccount;
    }

    @JsonIgnore
    public SellerPreInvoice purchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
        return this;
    }

    /**
     * 购方名称
     *
     * @return purchaserName
     **/
    @ApiModelProperty(value = "购方名称")
    public String getPurchaserName() {
        return purchaserName;
    }

    public void setPurchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
    }

    @JsonIgnore
    public SellerPreInvoice purchaserTenantId(String purchaserTenantId) {
        this.purchaserTenantId = purchaserTenantId;
        return this;
    }

    /**
     * 购方租户id
     *
     * @return purchaserTenantId
     **/
    @ApiModelProperty(value = "购方租户id")
    public String getPurchaserTenantId() {
        return purchaserTenantId;
    }

    public void setPurchaserTenantId(String purchaserTenantId) {
        this.purchaserTenantId = purchaserTenantId;
    }

    /**
     * 购方公司代码
     *
     * @return
     **/
    @ApiModelProperty(value = "购方公司代码")
    public String getPurchaserId() {
        return purchaserId;
    }

    public void setPurchaserId(String purchaserId) {
        this.purchaserId = purchaserId;
    }


    @JsonIgnore
    public SellerPreInvoice purchaserNo(String purchaserNo) {
        this.purchaserNo = purchaserNo;
        return this;
    }

    /**
     * 购方租户公司编号
     *
     * @return purchaserNo
     **/
    @ApiModelProperty(value = "购方租户公司编号")
    public String getPurchaserNo() {
        return purchaserNo;
    }

    public void setPurchaserNo(String purchaserNo) {
        this.purchaserNo = purchaserNo;
    }

    @JsonIgnore
    public SellerPreInvoice purchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo;
        return this;
    }

    /**
     * 购方纳税人识别号
     *
     * @return purchaserTaxNo
     **/
    @ApiModelProperty(value = "购方纳税人识别号")
    public String getPurchaserTaxNo() {
        return purchaserTaxNo;
    }

    public void setPurchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo;
    }

    @JsonIgnore
    public SellerPreInvoice purchaserTel(String purchaserTel) {
        this.purchaserTel = purchaserTel;
        return this;
    }

    /**
     * 购方电话
     *
     * @return purchaserTel
     **/
    @ApiModelProperty(value = "购方电话")
    public String getPurchaserTel() {
        return purchaserTel;
    }

    public void setPurchaserTel(String purchaserTel) {
        this.purchaserTel = purchaserTel;
    }

    @JsonIgnore
    public SellerPreInvoice purchaserAddress(String purchaserAddress) {
        this.purchaserAddress = purchaserAddress;
        return this;
    }

    /**
     * 购方地址
     *
     * @return purchaserAddress
     **/
    @ApiModelProperty(value = "购方地址")
    public String getPurchaserAddress() {
        return purchaserAddress;
    }

    public void setPurchaserAddress(String purchaserAddress) {
        this.purchaserAddress = purchaserAddress;
    }

    @JsonIgnore
    public SellerPreInvoice purchaserBankName(String purchaserBankName) {
        this.purchaserBankName = purchaserBankName;
        return this;
    }

    /**
     * 购方银行名称
     *
     * @return purchaserBankName
     **/
    @ApiModelProperty(value = "购方银行名称")
    public String getPurchaserBankName() {
        return purchaserBankName;
    }

    public void setPurchaserBankName(String purchaserBankName) {
        this.purchaserBankName = purchaserBankName;
    }

    @JsonIgnore
    public SellerPreInvoice purchaserBankAccount(String purchaserBankAccount) {
        this.purchaserBankAccount = purchaserBankAccount;
        return this;
    }

    /**
     * 购方银行账号
     *
     * @return purchaserBankAccount
     **/
    @ApiModelProperty(value = "购方银行账号")
    public String getPurchaserBankAccount() {
        return purchaserBankAccount;
    }

    public void setPurchaserBankAccount(String purchaserBankAccount) {
        this.purchaserBankAccount = purchaserBankAccount;
    }

    @JsonIgnore
    public SellerPreInvoice invoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
        return this;
    }

    /**
     * 发票类型
     *
     * @return invoiceType
     **/
    @ApiModelProperty(value = "发票类型")
    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    @JsonIgnore
    public SellerPreInvoice businessBillType(String businessBillType) {
        this.businessBillType = businessBillType;
        return this;
    }

    /**
     * 业务单据类型
     *
     * @return businessBillType
     **/
    @ApiModelProperty(value = "业务单据类型")
    public String getBusinessBillType() {
        return businessBillType;
    }

    public void setBusinessBillType(String businessBillType) {
        this.businessBillType = businessBillType;
    }

    @JsonIgnore
    public SellerPreInvoice salesbillType(String salesbillType) {
        this.salesbillType = salesbillType;
        return this;
    }

    /**
     * 单据类型
     *
     * @return salesbillType
     **/
    @ApiModelProperty(value = "单据类型")
    public String getSalesbillType() {
        return salesbillType;
    }

    public void setSalesbillType(String salesbillType) {
        this.salesbillType = salesbillType;
    }

    @JsonIgnore
    public SellerPreInvoice invoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
        return this;
    }

    /**
     * 发票代码
     *
     * @return invoiceCode
     **/
    @ApiModelProperty(value = "发票代码")
    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    @JsonIgnore
    public SellerPreInvoice invoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
        return this;
    }

    /**
     * 发票号码
     *
     * @return invoiceNo
     **/
    @ApiModelProperty(value = "发票号码")
    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    @JsonIgnore
    public SellerPreInvoice machineCode(String machineCode) {
        this.machineCode = machineCode;
        return this;
    }

    /**
     * 机器编码
     *
     * @return machineCode
     **/
    @ApiModelProperty(value = "机器编码")
    public String getMachineCode() {
        return machineCode;
    }

    public void setMachineCode(String machineCode) {
        this.machineCode = machineCode;
    }

    @JsonIgnore
    public SellerPreInvoice paperDrawDate(String paperDrawDate) {
        this.paperDrawDate = paperDrawDate;
        return this;
    }

    /**
     * 发票开票日期
     *
     * @return paperDrawDate
     **/
    @ApiModelProperty(value = "发票开票日期")
    public String getPaperDrawDate() {
        return paperDrawDate;
    }

    public void setPaperDrawDate(String paperDrawDate) {
        this.paperDrawDate = paperDrawDate;
    }

    @JsonIgnore
    public SellerPreInvoice checkCode(String checkCode) {
        this.checkCode = checkCode;
        return this;
    }

    /**
     * 校验码
     *
     * @return checkCode
     **/
    @ApiModelProperty(value = "校验码")
    public String getCheckCode() {
        return checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    @JsonIgnore
    public SellerPreInvoice cashierName(String cashierName) {
        this.cashierName = cashierName;
        return this;
    }

    /**
     * 收款人姓名
     *
     * @return cashierName
     **/
    @ApiModelProperty(value = "收款人姓名")
    public String getCashierName() {
        return cashierName;
    }

    public void setCashierName(String cashierName) {
        this.cashierName = cashierName;
    }

    @JsonIgnore
    public SellerPreInvoice checkerName(String checkerName) {
        this.checkerName = checkerName;
        return this;
    }

    /**
     * 复核人姓名
     *
     * @return checkerName
     **/
    @ApiModelProperty(value = "复核人姓名")
    public String getCheckerName() {
        return checkerName;
    }

    public void setCheckerName(String checkerName) {
        this.checkerName = checkerName;
    }

    @JsonIgnore
    public SellerPreInvoice invoicerName(String invoicerName) {
        this.invoicerName = invoicerName;
        return this;
    }

    /**
     * 开票人姓名
     *
     * @return invoicerName
     **/
    @ApiModelProperty(value = "开票人姓名")
    public String getInvoicerName() {
        return invoicerName;
    }

    public void setInvoicerName(String invoicerName) {
        this.invoicerName = invoicerName;
    }

    @JsonIgnore
    public SellerPreInvoice remark(String remark) {
        this.remark = remark;
        return this;
    }

    /**
     * 备注
     *
     * @return remark
     **/
    @ApiModelProperty(value = "备注")
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @JsonIgnore
    public SellerPreInvoice electronicSignature(String electronicSignature) {
        this.electronicSignature = electronicSignature;
        return this;
    }

    /**
     * 电子签名
     *
     * @return electronicSignature
     **/
    @ApiModelProperty(value = "电子签名")
    public String getElectronicSignature() {
        return electronicSignature;
    }

    public void setElectronicSignature(String electronicSignature) {
        this.electronicSignature = electronicSignature;
    }

    @JsonIgnore
    public SellerPreInvoice amountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
        return this;
    }

    /**
     * 含税金额
     *
     * @return amountWithTax
     **/
    @ApiModelProperty(value = "含税金额")
    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    @JsonIgnore
    public SellerPreInvoice amountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
        return this;
    }

    /**
     * 不含税金额
     *
     * @return amountWithoutTax
     **/
    @ApiModelProperty(value = "不含税金额")
    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    @JsonIgnore
    public SellerPreInvoice taxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    /**
     * 税额
     *
     * @return taxAmount
     **/
    @ApiModelProperty(value = "税额")
    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    @JsonIgnore
    public SellerPreInvoice cipherText(String cipherText) {
        this.cipherText = cipherText;
        return this;
    }

    /**
     * 密文
     *
     * @return cipherText
     **/
    @ApiModelProperty(value = "密文")
    public String getCipherText() {
        return cipherText;
    }

    public void setCipherText(String cipherText) {
        this.cipherText = cipherText;
    }

    @JsonIgnore
    public SellerPreInvoice cipherTextTwoCode(String cipherTextTwoCode) {
        this.cipherTextTwoCode = cipherTextTwoCode;
        return this;
    }

    /**
     * 二维密文
     *
     * @return cipherTextTwoCode
     **/
    @ApiModelProperty(value = "二维密文")
    public String getCipherTextTwoCode() {
        return cipherTextTwoCode;
    }

    public void setCipherTextTwoCode(String cipherTextTwoCode) {
        this.cipherTextTwoCode = cipherTextTwoCode;
    }

    @JsonIgnore
    public SellerPreInvoice lockFlag(Integer lockFlag) {
        this.lockFlag = lockFlag;
        return this;
    }

    /**
     * 是否锁定
     *
     * @return lockFlag
     **/
    @ApiModelProperty(value = "是否锁定")
    public Integer getLockFlag() {
        return lockFlag;
    }

    public void setLockFlag(Integer lockFlag) {
        this.lockFlag = lockFlag;
    }




    @JsonIgnore
    public SellerPreInvoice status(Integer status) {
        this.status = status;
        return this;
    }

    /**
     * 预制发票状态
     *
     * @return status
     **/
    @ApiModelProperty(value = "预制发票状态")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @JsonIgnore
    public SellerPreInvoice createTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
     * 发票正式信息回填时间
     *
     * @return createTime
     **/
    @ApiModelProperty(value = "发票正式信息回填时间")
    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonIgnore
    public SellerPreInvoice createUserId(String createUserId) {
        this.createUserId = createUserId;
        return this;
    }

    /**
     * 发票正式信息回填操作账号
     *
     * @return createUserId
     **/
    @ApiModelProperty(value = "发票正式信息回填操作账号")
    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    @JsonIgnore
    public SellerPreInvoice updateTime(Date updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    /**
     * 修改时间
     *
     * @return updateTime
     **/
    @ApiModelProperty(value = "修改时间")
    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @JsonIgnore
    public SellerPreInvoice updateUserId(String updateUserId) {
        this.updateUserId = updateUserId;
        return this;
    }

    /**
     * 更新账号
     *
     * @return updateUserId
     **/
    @ApiModelProperty(value = "更新账号")
    public String getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId;
    }

    @JsonIgnore
    public SellerPreInvoice ext1(String ext1) {
        this.ext1 = ext1;
        return this;
    }

    /**
     * ext1
     *
     * @return ext1
     **/
    @ApiModelProperty(value = "ext1")
    public String getExt1() {
        return ext1;
    }

    public void setExt1(String ext1) {
        this.ext1 = ext1;
    }

    @JsonIgnore
    public SellerPreInvoice ext2(String ext2) {
        this.ext2 = ext2;
        return this;
    }

    /**
     * ext2
     *
     * @return ext2
     **/
    @ApiModelProperty(value = "ext2")
    public String getExt2() {
        return ext2;
    }

    public void setExt2(String ext2) {
        this.ext2 = ext2;
    }

    @JsonIgnore
    public SellerPreInvoice ext3(String ext3) {
        this.ext3 = ext3;
        return this;
    }

    /**
     * ext3
     *
     * @return ext3
     **/
    @ApiModelProperty(value = "ext3")
    public String getExt3() {
        return ext3;
    }

    public void setExt3(String ext3) {
        this.ext3 = ext3;
    }

    @JsonIgnore
    public SellerPreInvoice ext4(String ext4) {
        this.ext4 = ext4;
        return this;
    }

    /**
     * ext4
     *
     * @return ext4
     **/
    @ApiModelProperty(value = "ext4")
    public String getExt4() {
        return ext4;
    }

    public void setExt4(String ext4) {
        this.ext4 = ext4;
    }

    @JsonIgnore
    public SellerPreInvoice ext5(String ext5) {
        this.ext5 = ext5;
        return this;
    }

    /**
     * ext5
     *
     * @return ext5
     **/
    @ApiModelProperty(value = "ext5")
    public String getExt5() {
        return ext5;
    }

    public void setExt5(String ext5) {
        this.ext5 = ext5;
    }

    @JsonIgnore
    public SellerPreInvoice ext6(String ext6) {
        this.ext6 = ext6;
        return this;
    }

    /**
     * ext6
     *
     * @return ext6
     **/
    @ApiModelProperty(value = "ext6")
    public String getExt6() {
        return ext6;
    }

    public void setExt6(String ext6) {
        this.ext6 = ext6;
    }

    @JsonIgnore
    public SellerPreInvoice ext7(String ext7) {
        this.ext7 = ext7;
        return this;
    }

    /**
     * ext7
     *
     * @return ext7
     **/
    @ApiModelProperty(value = "ext7")
    public String getExt7() {
        return ext7;
    }

    public void setExt7(String ext7) {
        this.ext7 = ext7;
    }

    @JsonIgnore
    public SellerPreInvoice ext8(String ext8) {
        this.ext8 = ext8;
        return this;
    }

    /**
     * ext8
     *
     * @return ext8
     **/
    @ApiModelProperty(value = "ext8")
    public String getExt8() {
        return ext8;
    }

    public void setExt8(String ext8) {
        this.ext8 = ext8;
    }

    @JsonIgnore
    public SellerPreInvoice ext9(String ext9) {
        this.ext9 = ext9;
        return this;
    }

    /**
     * ext9
     *
     * @return ext9
     **/
    @ApiModelProperty(value = "ext9")
    public String getExt9() {
        return ext9;
    }

    public void setExt9(String ext9) {
        this.ext9 = ext9;
    }

    @JsonIgnore
    public SellerPreInvoice ext10(String ext10) {
        this.ext10 = ext10;
        return this;
    }

    /**
     * ext10
     *
     * @return ext10
     **/
    @ApiModelProperty(value = "ext10")
    public String getExt10() {
        return ext10;
    }

    public void setExt10(String ext10) {
        this.ext10 = ext10;
    }

    @JsonIgnore
    public SellerPreInvoice ext11(String ext11) {
        this.ext11 = ext11;
        return this;
    }

    /**
     * ext11
     *
     * @return ext11
     **/
    @ApiModelProperty(value = "ext11")
    public String getExt11() {
        return ext11;
    }

    public void setExt11(String ext11) {
        this.ext11 = ext11;
    }

    @JsonIgnore
    public SellerPreInvoice ext12(String ext12) {
        this.ext12 = ext12;
        return this;
    }

    /**
     * ext12
     *
     * @return ext12
     **/
    @ApiModelProperty(value = "ext12")
    public String getExt12() {
        return ext12;
    }

    public void setExt12(String ext12) {
        this.ext12 = ext12;
    }

    @JsonIgnore
    public SellerPreInvoice ext13(String ext13) {
        this.ext13 = ext13;
        return this;
    }

    /**
     * ext13
     *
     * @return ext13
     **/
    @ApiModelProperty(value = "ext13")
    public String getExt13() {
        return ext13;
    }

    public void setExt13(String ext13) {
        this.ext13 = ext13;
    }

    @JsonIgnore
    public SellerPreInvoice ext14(String ext14) {
        this.ext14 = ext14;
        return this;
    }

    /**
     * ext14
     *
     * @return ext14
     **/
    @ApiModelProperty(value = "ext14")
    public String getExt14() {
        return ext14;
    }

    public void setExt14(String ext14) {
        this.ext14 = ext14;
    }

    @JsonIgnore
    public SellerPreInvoice ext15(String ext15) {
        this.ext15 = ext15;
        return this;
    }

    /**
     * ext15
     *
     * @return ext15
     **/
    @ApiModelProperty(value = "ext15")
    public String getExt15() {
        return ext15;
    }

    public void setExt15(String ext15) {
        this.ext15 = ext15;
    }

    @JsonIgnore
    public SellerPreInvoice ext16(String ext16) {
        this.ext16 = ext16;
        return this;
    }

    /**
     * ext16
     *
     * @return ext16
     **/
    @ApiModelProperty(value = "ext16")
    public String getExt16() {
        return ext16;
    }

    public void setExt16(String ext16) {
        this.ext16 = ext16;
    }

    @JsonIgnore
    public SellerPreInvoice ext17(String ext17) {
        this.ext17 = ext17;
        return this;
    }

    /**
     * ext17
     *
     * @return ext17
     **/
    @ApiModelProperty(value = "ext17")
    public String getExt17() {
        return ext17;
    }

    public void setExt17(String ext17) {
        this.ext17 = ext17;
    }

    @JsonIgnore
    public SellerPreInvoice ext18(String ext18) {
        this.ext18 = ext18;
        return this;
    }

    /**
     * ext18
     *
     * @return ext18
     **/
    @ApiModelProperty(value = "ext18")
    public String getExt18() {
        return ext18;
    }

    public void setExt18(String ext18) {
        this.ext18 = ext18;
    }

    @JsonIgnore
    public SellerPreInvoice ext19(String ext19) {
        this.ext19 = ext19;
        return this;
    }

    /**
     * ext19
     *
     * @return ext19
     **/
    @ApiModelProperty(value = "ext19")
    public String getExt19() {
        return ext19;
    }

    public void setExt19(String ext19) {
        this.ext19 = ext19;
    }

    @JsonIgnore
    public SellerPreInvoice ext20(String ext20) {
        this.ext20 = ext20;
        return this;
    }

    /**
     * ext20
     *
     * @return ext20
     **/
    @ApiModelProperty(value = "ext20")
    public String getExt20() {
        return ext20;
    }

    public void setExt20(String ext20) {
        this.ext20 = ext20;
    }

    @JsonIgnore
    public SellerPreInvoice ext21(String ext21) {
        this.ext21 = ext21;
        return this;
    }

    /**
     * ext21
     *
     * @return ext21
     **/
    @ApiModelProperty(value = "ext21")
    public String getExt21() {
        return ext21;
    }

    public void setExt21(String ext21) {
        this.ext21 = ext21;
    }

    @JsonIgnore
    public SellerPreInvoice ext22(String ext22) {
        this.ext22 = ext22;
        return this;
    }

    /**
     * ext22
     *
     * @return ext22
     **/
    @ApiModelProperty(value = "ext22")
    public String getExt22() {
        return ext22;
    }

    public void setExt22(String ext22) {
        this.ext22 = ext22;
    }

    @JsonIgnore
    public SellerPreInvoice ext23(String ext23) {
        this.ext23 = ext23;
        return this;
    }

    /**
     * ext23
     *
     * @return ext23
     **/
    @ApiModelProperty(value = "ext23")
    public String getExt23() {
        return ext23;
    }

    public void setExt23(String ext23) {
        this.ext23 = ext23;
    }

    @JsonIgnore
    public SellerPreInvoice ext24(String ext24) {
        this.ext24 = ext24;
        return this;
    }

    /**
     * ext24
     *
     * @return ext24
     **/
    @ApiModelProperty(value = "ext24")
    public String getExt24() {
        return ext24;
    }

    public void setExt24(String ext24) {
        this.ext24 = ext24;
    }

    @JsonIgnore
    public SellerPreInvoice ext25(String ext25) {
        this.ext25 = ext25;
        return this;
    }

    /**
     * ext25
     *
     * @return ext25
     **/
    @ApiModelProperty(value = "ext25")
    public String getExt25() {
        return ext25;
    }

    public void setExt25(String ext25) {
        this.ext25 = ext25;
    }






    public Long getRuleId() {
        return ruleId;
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }

    public Long getOutBatchNo() {
        return outBatchNo;
    }

    public void setOutBatchNo(Long outBatchNo) {
        this.outBatchNo = outBatchNo;
    }

    @JsonIgnore
    public SellerPreInvoice originInvoiceNo(String originInvoiceNo) {
        this.originInvoiceNo = originInvoiceNo;
        return this;
    }

    /**
     * 原发票号码
     * @return originInvoiceNo
     **/
    @ApiModelProperty(value = "原发票号码")
    public String getOriginInvoiceNo() {
        return originInvoiceNo;
    }

    public void setOriginInvoiceNo(String originInvoiceNo) {
        this.originInvoiceNo = originInvoiceNo;
    }

    @JsonIgnore
    public SellerPreInvoice originInvoiceCode(String originInvoiceCode) {
        this.originInvoiceCode = originInvoiceCode;
        return this;
    }

    /**
     * 原发票代码
     * @return originInvoiceCode
     **/
    @ApiModelProperty(value = "原发票代码")
    public String getOriginInvoiceCode() {
        return originInvoiceCode;
    }

    public void setOriginInvoiceCode(String originInvoiceCode) {
        this.originInvoiceCode = originInvoiceCode;
    }

    @JsonIgnore
    public SellerPreInvoice redNotificationNo(String redNotificationNo) {
        this.redNotificationNo = redNotificationNo;
        return this;
    }

    /**
     * 红字信息编号
     * @return redNotification
     **/
    @ApiModelProperty(value = "红字信息编号")
    public String getRedNotificationNo() {
        return redNotificationNo;
    }

    public void setRedNotificationNo(String redNotificationNo) {
        this.redNotificationNo = redNotificationNo;
    }
    @Override
    public String toString() {
        return "SellerPreInvoice{" +
                "id=" + id +
                ", salesbillNo=" + salesbillNo +
                ", batchNo=" + batchNo +
                ", outBatchNo=" + outBatchNo +
                ", sellerTenantId='" + sellerTenantId + '\'' +
                ", sellerNo='" + sellerNo + '\'' +
                ", sellerCode='" + sellerCode + '\'' +
                ", sellerName='" + sellerName + '\'' +
                ", sellerTaxNo='" + sellerTaxNo + '\'' +
                ", sellerTel='" + sellerTel + '\'' +
                ", sellerAddress='" + sellerAddress + '\'' +
                ", sellerBankName='" + sellerBankName + '\'' +
                ", sellerBankAccount='" + sellerBankAccount + '\'' +
                ", purchaserName='" + purchaserName + '\'' +
                ", purchaserTenantId='" + purchaserTenantId + '\'' +
                ", purchaserId='" + purchaserId + '\'' +
                ", purchaserNo='" + purchaserNo + '\'' +
                ", purchaserTaxNo='" + purchaserTaxNo + '\'' +
                ", purchaserTel='" + purchaserTel + '\'' +
                ", purchaserAddress='" + purchaserAddress + '\'' +
                ", purchaserBankName='" + purchaserBankName + '\'' +
                ", purchaserBankAccount='" + purchaserBankAccount + '\'' +
                ", invoiceType='" + invoiceType + '\'' +
                ", businessBillType='" + businessBillType + '\'' +
                ", salesbillType='" + salesbillType + '\'' +
                ", invoiceCode='" + invoiceCode + '\'' +
                ", invoiceNo='" + invoiceNo + '\'' +
                ", machineCode='" + machineCode + '\'' +
                ", paperDrawDate='" + paperDrawDate + '\'' +
                ", checkCode='" + checkCode + '\'' +
                ", cashierName='" + cashierName + '\'' +
                ", checkerName='" + checkerName + '\'' +
                ", invoicerName='" + invoicerName + '\'' +
                ", remark='" + remark + '\'' +
                ", electronicSignature='" + electronicSignature + '\'' +
                ", amountWithTax=" + amountWithTax +
                ", amountWithoutTax=" + amountWithoutTax +
                ", taxAmount=" + taxAmount +
                ", cipherText='" + cipherText + '\'' +
                ", cipherTextTwoCode='" + cipherTextTwoCode + '\'' +
                ", lockFlag=" + lockFlag +
                ", status=" + status +
                ", createTime=" + createTime +
                ", createUserId='" + createUserId + '\'' +
                ", updateTime=" + updateTime +
                ", updateUserId='" + updateUserId + '\'' +
                ", ext1='" + ext1 + '\'' +
                ", ext2='" + ext2 + '\'' +
                ", ext3='" + ext3 + '\'' +
                ", ext4='" + ext4 + '\'' +
                ", ext5='" + ext5 + '\'' +
                ", ext6='" + ext6 + '\'' +
                ", ext7='" + ext7 + '\'' +
                ", ext8='" + ext8 + '\'' +
                ", ext9='" + ext9 + '\'' +
                ", ext10='" + ext10 + '\'' +
                ", ext11='" + ext11 + '\'' +
                ", ext12='" + ext12 + '\'' +
                ", ext13='" + ext13 + '\'' +
                ", ext14='" + ext14 + '\'' +
                ", ext15='" + ext15 + '\'' +
                ", ext16='" + ext16 + '\'' +
                ", ext17='" + ext17 + '\'' +
                ", ext18='" + ext18 + '\'' +
                ", ext19='" + ext19 + '\'' +
                ", ext20='" + ext20 + '\'' +
                ", ext21='" + ext21 + '\'' +
                ", ext22='" + ext22 + '\'' +
                ", ext23='" + ext23 + '\'' +
                ", ext24='" + ext24 + '\'' +
                ", ext25='" + ext25 + '\'' +
                ", ruleId=" + ruleId +'\'' +
                ", originInvoiceNo=" + originInvoiceNo +'\'' +
                ", originInvoiceCode=" + originInvoiceCode +'\'' +
                ", redNotificationNo=" + redNotificationNo +'\'' +
                '}';
    }
}
