package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * SellerPreInvoiceQueryByConditionRequest
 */

@JsonInclude(NON_NULL)
public class SellerPreInvoiceQueryByConditionRequest {
  @JsonProperty("pageNo")
  @Min(value = 1, message = "页码不能小于1")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  @Min(value = 1, message = "每页数据不能小于1")
  private Integer pageSize = null;

  @JsonProperty("status")
  @NotBlank(message = "状态不能为空")
  private String status = null;

  @JsonProperty("userRole")
  private String userRole = null;

  @JsonProperty("sort")
  private Sort sort = null;

  @ApiModelProperty("搜索查询范围")
  private List<Long> createTime;

  @JsonProperty("groups")
  private List<List<RequestField>> groups = new ArrayList<List<RequestField>>();

  @JsonIgnore
  public SellerPreInvoiceQueryByConditionRequest pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * 页码
   * @return pageNo
  **/
  @ApiModelProperty(value = "页码")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public SellerPreInvoiceQueryByConditionRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 每页数据量
   * @return pageSize
  **/
  @ApiModelProperty(value = "每页数据量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public SellerPreInvoiceQueryByConditionRequest status(String status) {
    this.status = status;
    return this;
  }

   /**
   * 分类状态，wait_confirmed=待确认,change=有变更,confirming=对方确认中,pending_invoice=待开票
   * @return status
  **/
  @ApiModelProperty(value = "分类状态，wait_confirmed=待确认,change=有变更,confirming=对方确认中,pending_invoice=待开票")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  @JsonIgnore
  public SellerPreInvoiceQueryByConditionRequest userRole(String userRole) {
    this.userRole = userRole;
    return this;
  }

   /**
   * seller-销项、purchaser-进项
   * @return userRole
  **/
  @ApiModelProperty(value = "seller-销项、purchaser-进项")
  public String getUserRole() {
    return userRole;
  }

  public void setUserRole(String userRole) {
    this.userRole = userRole;
  }

  @JsonIgnore
  public SellerPreInvoiceQueryByConditionRequest sort(Sort sort) {
    this.sort = sort;
    return this;
  }

   /**
   * Get sort
   * @return sort
  **/
  @ApiModelProperty(value = "")
  public Sort getSort() {
    return sort;
  }

  public void setSort(Sort sort) {
    this.sort = sort;
  }

  @JsonIgnore
  public SellerPreInvoiceQueryByConditionRequest filters(List<List<RequestField>> filters) {
    this.groups = filters;
    return this;
  }

  public SellerPreInvoiceQueryByConditionRequest addFiltersItem(List<RequestField> filtersItem) {
    this.groups.add(filtersItem);
    return this;
  }

  public List<Long> getCreateTime() {
    return createTime;
  }

  public void setCreateTime(List<Long> createTime) {
    this.createTime = createTime;
  }

  /**
   * 过滤器条件
    * @return groups
  **/
  @ApiModelProperty(value = "过滤器条件")
  public List<List<RequestField>> getGroups() {
    return groups;
  }

  public void setGroups(List<List<RequestField>> groups) {
    this.groups = groups;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SellerPreInvoiceQueryByConditionRequest sellerPreInvoiceQueryByConditionRequest = (SellerPreInvoiceQueryByConditionRequest) o;
    return Objects.equals(this.pageNo, sellerPreInvoiceQueryByConditionRequest.pageNo) &&
        Objects.equals(this.pageSize, sellerPreInvoiceQueryByConditionRequest.pageSize) &&
        Objects.equals(this.status, sellerPreInvoiceQueryByConditionRequest.status) &&
        Objects.equals(this.userRole, sellerPreInvoiceQueryByConditionRequest.userRole) &&
        Objects.equals(this.sort, sellerPreInvoiceQueryByConditionRequest.sort) &&
            Objects.equals(this.groups, sellerPreInvoiceQueryByConditionRequest.groups);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pageNo, pageSize, status, userRole, sort, groups);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SellerPreInvoiceQueryByConditionRequest {\n");

    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    userRole: ").append(toIndentedString(userRole)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
