package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/8/1 16:48
 */
@JsonInclude(NON_NULL)
public class SplitPreInvoiceRequest {

    /**
     * 单据信息
     */
    @NotNull(message = "单据信息不能为空")
    @JsonProperty("billInfo")
    @ApiModelProperty("单据信息")
    private BillInfo billInfo;

    @JsonProperty("mergeType")
    @ApiModelProperty("合并类型 0-无组合合并 1-自动组合 2-自动合并")
    private int mergeType;

    /**
     * 拆票规则
     */
    @NotNull(message = "拆票规则不能为空")
    @JsonProperty("splitRule")
    @ApiModelProperty("拆票规则")
    private SplitRule splitRule;

    @JsonProperty("batchNo")
    @ApiModelProperty("批次号")
    private Long batchNo;

    /**
     * 自动开具终端代码
     */
    @JsonProperty("terminalCode")
    @ApiModelProperty("自动开具终端代码")
    private String terminalCode;

    @JsonProperty("splitType")
    @ApiModelProperty("自动拆票flag 0-手动拆票 1-自动拆票")
    private int splitType;


    /**
     * 请求任务id 不用传
     */
    private Long taskId;

    public int getSplitType() {
        return splitType;
    }

    public void setSplitType(int splitType) {
        this.splitType = splitType;
    }

    public Long getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(Long batchNo) {
        this.batchNo = batchNo;
    }

    public Long getTaskId() {
        return taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public int getMergeType() {
        return mergeType;
    }

    public void setMergeType(int mergeType) {
        this.mergeType = mergeType;
    }

    public BillInfo getBillInfo() {
        return billInfo;
    }

    public void setBillInfo(BillInfo billInfo) {
        this.billInfo = billInfo;
    }

    public SplitRule getSplitRule() {
        return splitRule;
    }

    public void setSplitRule(SplitRule splitRule) {
        this.splitRule = splitRule;
    }

    public String getTerminalCode() {
        return terminalCode;
    }

    public void setTerminalCode(String terminalCode) {
        this.terminalCode = terminalCode;
    }
}
