package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * LockInvoiceByIdsResponse
 */

@JsonInclude(NON_NULL)
public class UnLockInvoiceByCodeResponse {
    @JsonProperty("code")
    private Integer code = 1;

    @JsonProperty("message")
    private String message = "获取成功!";


    public LockInvoiceByCodeResult getResult() {
        return result;
    }

    public void setResult(LockInvoiceByCodeResult result) {
        this.result = result;
    }

    @JsonProperty("result")
    private LockInvoiceByCodeResult result = null;

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }



    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        UnLockInvoiceByCodeResponse that = (UnLockInvoiceByCodeResponse) o;
        return Objects.equals(code, that.code) &&
                Objects.equals(message, that.message) &&
                Objects.equals(result, that.result);
    }

    @Override
    public int hashCode() {
        return Objects.hash(code, message, result);
    }
}
