package com.xforceplus.seller.invoice.client.model.pdf;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;

public class AutoPdfControlInfo {
    @JsonProperty("templateVersion")
    private String templateVersion = null;
    @JsonProperty("productOil")
    private String productOil = null;

    public AutoPdfControlInfo(String templateVersion, String productOil) {
        this.templateVersion = templateVersion;
        this.productOil = productOil;
    }

    public AutoPdfControlInfo() {
    }

    @JsonIgnore
    public AutoPdfControlInfo templateVersion(String templateVersion) {
        this.templateVersion = templateVersion;
        return this;
    }

    @ApiModelProperty("版式文件版本 (0-使用5行模版, 1-使用8行模版，无值等同0)(仅服务器开电票使用)")
    public String getTemplateVersion() {
        return this.templateVersion;
    }

    public void setTemplateVersion(String templateVersion) {
        this.templateVersion = templateVersion;
    }

    @JsonIgnore
    public AutoPdfControlInfo productOil(String productOil) {
        this.productOil = productOil;
        return this;
    }

    @Valid
    @ApiModelProperty("成品油标识")
    public String getProductOil() {
        return this.productOil;
    }

    public void setProductOil(String productOil) {
        this.productOil = productOil;
    }

    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }

}
