package com.xforceplus.seller.invoice.clientl.v2.mode;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;


@ApiModel(
        description = "折扣信息"
)
public class DiscountAmountInfo {

    @JsonProperty("discountTax")
    private BigDecimal discountTax = null;
    @JsonProperty("discountWithoutTax")
    private BigDecimal discountWithoutTax = null;


    public DiscountAmountInfo(BigDecimal discountTax, BigDecimal discountWithoutTax) {
        this.discountTax = discountTax;
        this.discountWithoutTax = discountWithoutTax;
    }

    public DiscountAmountInfo() {
    }

    @JsonIgnore
    public DiscountAmountInfo discountTax(BigDecimal discountTax) {
        this.discountTax = discountTax;
        return this;
    }

    @ApiModelProperty("折扣税额(小数点保留最多2位)")
    public BigDecimal getDiscountTax() {
        return this.discountTax;
    }

    public void setDiscountTax(BigDecimal discountTax) {
        this.discountTax = discountTax;
    }

    @JsonIgnore
    public DiscountAmountInfo discountWithoutTax(BigDecimal discountWithoutTax) {
        this.discountWithoutTax = discountWithoutTax;
        return this;
    }

    @ApiModelProperty("不含税折扣额(小数点保留最多2位)")
    public BigDecimal getDiscountWithoutTax() {
        return this.discountWithoutTax;
    }

    public void setDiscountWithoutTax(BigDecimal discountWithoutTax) {
        this.discountWithoutTax = discountWithoutTax;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DiscountAmountInfo that = (DiscountAmountInfo) o;
        return Objects.equals(discountTax, that.discountTax) &&
                Objects.equals(discountWithoutTax, that.discountWithoutTax);
    }

    @Override
    public int hashCode() {
        return Objects.hash(discountTax, discountWithoutTax);
    }

    @Override
    public String toString() {
        return "DiscountAmountInfo{" +
                "discountTax='" + discountTax + '\'' +
                ", discountWithoutTax='" + discountWithoutTax + '\'' +
                '}';
    }
    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }

}
