package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.AutoInvoiceRequest;
import com.xforceplus.seller.invoice.client.model.ResendMakeOutInvoiceRequest;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;



/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/8/8 18:35
 */
public interface AutoInvoiceApi {

    @ApiOperation(value = "自动开具接口", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"AutoInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "自动开具接口返回", response = Response.class)})
    @RequestMapping(value = "/pre-invoice/auto-invoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response autoInvoice(@ApiParam(value = "自动开具请求", required = true) @RequestBody AutoInvoiceRequest autoInvoiceRequest);


    @ApiOperation(value = "重新发起开具请求接口", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"AutoInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "自动开具接口返回", response = Response.class)})
    @RequestMapping(value = "/pre-invoice/resend-invoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response resendMakeOutInvoice(@ApiParam(value = "自动开具请求", required = true) @RequestBody ResendMakeOutInvoiceRequest request);
}
