package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.AutoInvoiceRequest;
import com.xforceplus.seller.invoice.client.model.SellerInvoiceInfo;
import com.xforceplus.seller.invoice.client.model.update.BillingSellerInvoiceInfo;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 *
 * @author weidejiang
 */
public interface BillingCenterApi {

    @ApiOperation(value = "发送计费中心", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"AutoInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "自动开具接口返回", response = Response.class)})
    @RequestMapping(value = "/billing-center/send",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response sendBillingCenter(@ApiParam(value = "发票信息", required = true) @RequestBody BillingSellerInvoiceInfo sellerInvoiceInfo);

}
