package com.xforceplus.seller.invoice.client.api;


import com.xforceplus.seller.invoice.client.model.*;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "FiberRemodelSellerAudit", description = "the FiberRemodelSellerAudit API")
public interface FiberRemodelSellerAuditApi {

    @ApiOperation(value = "提交发票作废申请单", notes = "", response = InvSellerInvoiceVoidBillResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerAuditVoidBill", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = InvSellerInvoiceVoidBillResponse.class) })
    @RequestMapping(value = "/invoice/submitVoidApplyBill",
            produces = { "application/json" },
            method = RequestMethod.POST)
    InvSellerInvoiceVoidBillResponse submitVoidApplyBill(@RequestBody InvSellerInvoiceVoidBillRequest request);


    @ApiOperation(value = "修改发票申请单", notes = "", response = InvSellerInvoiceVoidBillResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerAuditVoidBill", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = InvSellerInvoiceVoidBillResponse.class) })
    @RequestMapping(value = "/invoice/editVoidApplyBill",
            produces = { "application/json" },
            method = RequestMethod.POST)
    InvSellerInvoiceVoidBillResponse editVoidApplyBill(@RequestBody SellerInvoiceEditVoidBillRequest request);

    @ApiOperation(value = "查看发票申请单详情", notes = "", response = InvSellerInvoiceVoidBillResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerAuditVoidBill", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = InvSellerInvoiceVoidBillResponse.class) })
    @RequestMapping(value = "/invoice/queryApplyVoidBillInfo",
            produces = { "application/json" },
            method = RequestMethod.POST)
    InvSellerInvoiceVoidBillResponse<QueryInvoiceVoidBillInfo> queryApplyVoidBillInfo(@RequestBody QuerySellerInvoiceVoidBillRequest request);

    @ApiOperation(value = "取消发票申请", notes = "", response = InvSellerInvoiceVoidBillResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerAuditVoidBill", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = InvSellerInvoiceVoidBillResponse.class) })
    @RequestMapping(value = "/invoice/cancelApplyBill",
            produces = { "application/json" },
            method = RequestMethod.POST)
    InvSellerInvoiceVoidBillResponse cancelApplyBill(@RequestBody CancelApplyBillRequest request);

    @ApiOperation(value = "是否填写申请单判断", notes = "", response = InvSellerInvoiceVoidBillResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerAuditVoidBill", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = InvSellerInvoiceVoidBillResponse.class) })
    @RequestMapping(value = "/invoice/writeBillCheck",
            produces = { "application/json" },
            method = RequestMethod.POST)
    InvSellerInvoiceVoidBillResponse writeBillCheck(@RequestBody CheckWriteInvoiceRequest request);
}
