package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.*;
import com.xforceplus.seller.invoice.client.model.invoice.RedFlushInvoiceNoDirectRequest;
import com.xforceplus.seller.invoice.client.model.DataListResult;
import com.xforceplus.seller.invoice.clientl.v2.request.QueryMakeOutResultRequest;
import com.xforceplus.seller.invoice.clientl.v2.response.QueryMakeOutResultResponse;
import com.xforceplus.xplatframework.apimodel.BaseAsyncResponse;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@Api(value = "invoice", description = "the invoice API")
public interface InvoiceApi {

    @ApiOperation(value = "发票 - 查询发票详情", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/getInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response getSellerInvoice(@ApiParam(value = "发票号码和代码", required = true) @RequestBody MsQueryInvoiceRequest request);

    /*
    @ApiOperation(value = "发票查询", notes = "", response = JobSellerInvoiceRequest.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = JobSellerInvoiceRequest.class) })
    @RequestMapping(value = "/invoice/querySellerInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    JobSellerInvoiceModel querySellerInvoice(@ApiParam(value = "发票查询请求", required = true) @RequestBody JobSellerInvoiceRequest request);
    */

    @ApiOperation(value = "作废 - 通用校验接口", notes = "", response = AbandonInvoiceCheckResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "打印校验通用接口返回", response = AbandonInvoiceCheckResponse.class) })
    @RequestMapping(value = "/invoice/abandonInvoiceCheck",
            produces = { "application/json" },
            method = RequestMethod.POST)
    AbandonInvoiceCheckResponse abandonInvoiceCheck(@ApiParam(value = "打印发票号列表", required = true) @RequestBody AbandonInvoiceCheckRequest abandonInvoiceCheckRequest);

    @ApiOperation(value = "发票作废 - 按照发票号作废", notes = "", response = BaseAsyncResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = BaseAsyncResponse.class) })
    @RequestMapping(value = "/invoice/abandonInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    BaseAsyncResponse abandonInvoice(@ApiParam(value = "废弃发票id列表", required = true) @RequestBody AbandonSellerInvoiceRequest abandonSellerInvoiceRequest);

    @ApiOperation(value = "发票 - 申请退票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/applyRefund",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response applyRefund(@ApiParam(value = "申请退票", required = true) @RequestBody ApplyRefundRequest applyRefundRequest);


    @ApiOperation(value = "发票 - pdf生成（含销货清单）", notes = "", response = ExportInvoicePDFResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = ExportInvoicePDFResponse.class) })
    @RequestMapping(value = "invoice/exportInvoicePDF",
            produces = { "application/json" },
            method = RequestMethod.POST)
    ExportInvoicePDFResponse exportInvoicePDF(@ApiParam(value = "导出发票（或含销货清单）pdf", required = true) @RequestBody ExportInvoicePDFRequest exportInvoicePDFRequest);


    @ApiOperation(value = "发票 - pdf生成（含销货清单）", notes = "", response = ExportInvoicePDFResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = ExportInvoicePDFResponse.class) })
    @RequestMapping(value = "invoice/searchInvoicePDF",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response<ExportInvoiceData> searchExportInvoicePDF(@ApiParam(value = "导出发票（或含销货清单）pdf", required = true) @RequestBody ExportInvoicePDFRequest exportInvoicePDFRequest);

    @ApiOperation(value = "发票 - 锁定", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/lockInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response lockInvoice(@ApiParam(value = "锁定", required = true) @RequestBody LockInvoiceRequest lockInvoiceRequest);

    @ApiOperation(value = "发票 - 根据id列表锁定", notes = "", response = LockInvoiceByIdsResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = LockInvoiceByIdsResponse.class) })
    @RequestMapping(value = "/invoice/lockInvoicesByIds",
            produces = { "application/json" },
            method = RequestMethod.POST)
    LockInvoiceByIdsResponse lockInvoicesByIds(@ApiParam(value = "根据id列表锁定", required = true) @RequestBody LockInvoiceByIdsRequest lockInvoiceByIdsRequest);


    @ApiOperation(value = "发票 - 根据发票号码代码锁定", notes = "", response = LockInvoiceByIdsResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = LockInvoiceByIdsResponse.class) })
    @RequestMapping(value = "/invoice/lockInvoicesByApi",
            produces = { "application/json" },
            method = RequestMethod.POST)
    LockInvoiceByCodeResponse lockInvoicesByApi(@ApiParam(value = "根据发票号码代码锁定", required = true) @RequestBody ApiLockInvoiceRequest apiLockInvoiceRequest);


    @ApiOperation(value = "发票 - 根据发票号码代码锁定", notes = "", response = LockInvoiceByIdsResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = LockInvoiceByIdsResponse.class) })
    @RequestMapping(value = "/invoice/unLockInvoicesByApi",
            produces = { "application/json" },
            method = RequestMethod.POST)
    UnLockInvoiceByCodeResponse unLockInvoicesByApi(@ApiParam(value = "根据发票号码代码锁定", required = true) @RequestBody ApiUnLockInvoiceRequest apiUnLockInvoiceRequest);



    @ApiOperation(value = "发票 - 外部审核状态", notes = "", response = OutBatchNoFlagResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = OutBatchNoFlagResponse.class) })
    @RequestMapping(value = "/invoice/outCheckInvoicesByIds",
            produces = { "application/json" },
            method = RequestMethod.POST)
    OutBatchNoFlagResponse outCheckInvoicesByIds(@ApiParam(value = "外部审核状态", required = true) @RequestBody OutCheckInvoicesByIdsRequest outCheckInvoicesByIdsRequest);

    @ApiOperation(value = "发票打印-基础接口", notes = "", response = BaseAsyncResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = BaseAsyncResponse.class) })
    @RequestMapping(value = "/invoice/basePrintInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    BaseAsyncResponse basePrintInvoice(@ApiParam(value = "打印发票号列表", required = true) @RequestBody BasePrintSellerInvoiceRequest basePrintSellerInvoiceRequest);

    @ApiOperation(value = "发票基础打印-轮询接口", notes = "", response = PollingBasePrintInvoiceResultResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = PollingBasePrintInvoiceResultResponse.class) })
    @RequestMapping(value = "/invoice/pollingBasePrintInvoiceResult",
            produces = { "application/json" },
            method = RequestMethod.POST)
    PollingBasePrintInvoiceResultResponse pollingBasePrintInvoiceResult(@ApiParam(value = "轮询通用请求（任务id）", required = true) @RequestBody PollingBaseRequest pollingBaseRequest);


    @ApiOperation(value = "打印发票或销货清单接口", notes = "", response = BaseAsyncResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = BaseAsyncResponse.class) })
    @RequestMapping(value = "/invoice/printInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    BaseAsyncResponse printInvoice(@ApiParam(value = "打印发票号列表", required = true) @RequestBody PrintSellerInvoiceRequest printSellerInvoiceRequest);

    @ApiOperation(value = "打印发票或销货清单--轮训结果接口", notes = "", response = PollingPrintInvoiceResultResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = PollingPrintInvoiceResultResponse.class) })
    @RequestMapping(value = "/invoice/pollingPrintInvoiceResult",
            produces = { "application/json" },
            method = RequestMethod.POST)
    PollingPrintInvoiceResultResponse pollingPrintInvoiceResult(@ApiParam(value = "轮询通用请求（任务id）", required = true) @RequestBody PollingBaseRequest pollingBaseRequest);

    @ApiOperation(value = "打印 - 通用校验接口", notes = "", response = PrintSellerInvoiceCheckResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "打印校验通用接口返回", response = PrintSellerInvoiceCheckResponse.class) })
    @RequestMapping(value = "/invoice/printInvoiceCheck",
            produces = { "application/json" },
            method = RequestMethod.POST)
    PrintSellerInvoiceCheckResponse printInvoiceCheck(@ApiParam(value = "打印发票号列表", required = true) @RequestBody PrintSellerInvoiceCheckRequest printSellerInvoiceCheckRequest);


    @ApiOperation(value = "发票 - 打印销货清单", notes = "", response = BaseAsyncResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = BaseAsyncResponse.class) })
    @RequestMapping(value = "/invoice/printSaleList",
            produces = { "application/json" },
            method = RequestMethod.POST)
    BaseAsyncResponse printSaleList(@ApiParam(value = "打印销货清单", required = true) @RequestBody PrintSaleListRequest printSaleListRequest);

    @ApiOperation(value = "发票 - 打印销货清单轮训接口", notes = "", response = PollingPrintSellListResultResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = PollingPrintSellListResultResponse.class) })
    @RequestMapping(value = "/invoice/pollingPrintSaleListResult",
            produces = { "application/json" },
            method = RequestMethod.POST)
    PollingPrintSellListResultResponse pollingPrintSaleListResult(@ApiParam(value = "轮询通用请求（任务id）", required = true) @RequestBody PollingBaseRequest pollingBaseRequest);

    @ApiOperation(value = "查询发票对应的单据的明细信息", notes = "", response = QueryBillDetailsResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "单据明细查询返回", response = QueryBillDetailsResponse.class) })
    @RequestMapping(value = "/invoice/queryBillDetails",
            produces = { "application/json" },
            method = RequestMethod.POST)
    QueryBillDetailsResponse queryBillDetails(@ApiParam(value = "单据id", required = true) @RequestBody QueryBillDetailsRequest queryBillDetailsRequest);


    @ApiOperation(value = "发票管理 - 获取邮箱列表", notes = "", response = QueryEmailBoxListResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "邮箱查询返回", response = QueryEmailBoxListResponse.class) })
    @RequestMapping(value = "invoice/queryEmailBoxList",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response queryEmailBoxList(@ApiParam(value = "获取邮箱列表", required = true) @RequestBody QueryEmailBoxListRequest queryEmailBoxListRequest);


    @ApiOperation(value = "发票查询", notes = "", response = SellerInvoiceQueryResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SellerInvoiceQueryResponse.class) })
    @RequestMapping(value = "/invoice/queryInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    SellerInvoiceQueryResponse queryInvoice(@ApiParam(value = "发票查询请求") @RequestBody SellerInvoiceQueryByConditionRequest sellerInvoiceQueryByConditionRequest);

    @ApiOperation(value = "发票统计", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/invoice/summary",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<InvoiceSummaryReply> summary(@ApiParam(value = "发票统计", required = true) @RequestBody SellerInvoiceQueryByConditionRequest request);

    @ApiOperation(value = "发票明细查询", notes = "", response = SellerInvoiceQueryResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SellerInvoiceItemQueryResponse.class) })
    @RequestMapping(value = "/invoice/queryInvoiceItem",
            produces = { "application/json" },
            method = RequestMethod.POST)
    SellerInvoiceItemQueryResponse queryInvoiceItem(@ApiParam(value = "发票查询请求") @RequestBody SellerInvoiceQueryByConditionRequest sellerInvoiceQueryByConditionRequest);


    @ApiOperation(value = "发票详情-包含发票信息、发票明细信息列表、发票操作日志列表", notes = "", response = InvoiceDetailsInfoResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "发票详情返回", response = InvoiceDetailsInfoResponse.class) })
    @RequestMapping(value = "/invoice/queryInvoiceDetailsById",
            produces = { "application/json" },
            method = RequestMethod.POST)
    InvoiceDetailsInfoResponse queryInvoiceDetailsById(@ApiParam(value = "发票id", required = true) @RequestBody QuerySellerInvoiceDetailsRequest querySellerInvoiceDetailsRequest);

    @ApiOperation(value = "发票操作日志列表", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "发票日志返回", response = Response.class) })
    @RequestMapping(value = "/invoice/queryLogsById",
            produces = { "application/json" },
            method = RequestMethod.POST)
   Response queryInvoiceLogs(@ApiParam(value = "发票id", required = true) @RequestBody LogRequest request);

    @ApiOperation(value = "发票红冲 - 发票红冲", notes = "", response = RedflushSellerInvoiceCheckResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = RedflushSellerInvoiceCheckResponse.class) })
    @RequestMapping(value = "/invoice/redFlushInvoiceCheck",
            produces = { "application/json" },
            method = RequestMethod.POST)
    RedflushSellerInvoiceCheckResponse redFlushInvoiceCheck(@ApiParam(value = "红冲发票号列表", required = true) @RequestBody RedflushSellerInvoiceCheckRequest redflushSellerInvoiceRequest);


    @ApiOperation(value = "发票红冲 - 发票红冲", notes = "", response = BaseAsyncResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = BaseAsyncResponse.class) })
    @RequestMapping(value = "/invoice/redFlushInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    BaseAsyncResponse redFlushInvoice(@ApiParam(value = "红冲发票号列表", required = true) @RequestBody RedflushSellerInvoiceRequest redflushSellerInvoiceRequest);

    @ApiOperation(value = "发票红冲 - 轮训结果", notes = "", response = PollingRedFlushInvoiceResultResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = PollingRedFlushInvoiceResultResponse.class) })
    @RequestMapping(value = "/invoice/pollingRedFlushInvoiceResult",
            produces = { "application/json" },
            method = RequestMethod.POST)
    PollingRedFlushInvoiceResultResponse pollingRedFlushInvoiceResult(@ApiParam(value = "轮询通用请求（任务id）", required = true) @RequestBody PollingBaseRequest pollingBaseRequest);

    @ApiOperation(value = "发票 - 驳回", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/reject",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response reject(@ApiParam(value = "驳回", required = true) @RequestBody RejectRequest rejectRequest);


    @ApiOperation(value = "发票 - 发送电票邮件", notes = "", response = BaseAsyncResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = BaseAsyncResponse.class) })
    @RequestMapping(value = "invoice/sendEinvoiceEmail",
            produces = { "application/json" },
            method = RequestMethod.POST)
    BaseAsyncResponse sendEinvoiceEmail(@ApiParam(value = "发送电票邮件", required = true) @RequestBody SendEinvoiceEmailRequest sendEinvoiceEmailRequest);


    @ApiOperation(value = "查询发票对应的单据列表", notes = "", response = ShowInvoiceBillsResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "单据列表查询返回", response = ShowInvoiceBillsResponse.class) })
    @RequestMapping(value = "/invoice/showInvoiceBills",
            produces = { "application/json" },
            method = RequestMethod.POST)
    ShowInvoiceBillsResponse showInvoiceBills(@ApiParam(value = "发票id", required = true) @RequestBody ShowInvoiceBillsRequest showInvoiceBillsRequest);

    @ApiOperation(value = "发票 - 解锁", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/unlockInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response unlockInvoice(@ApiParam(value = "解锁", required = true) @RequestBody UnlockInvoiceRequest unlockInvoiceRequest);

    @ApiOperation(value = "发票批次号查询", notes = "", response = InvoiceBatchNosQueryByConditionResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "发票批次号查询返回", response = InvoiceBatchNosQueryByConditionResponse.class) })
    @RequestMapping(value = "/invoice/queryInvoiceBatchNos",
            produces = { "application/json" },
            method = RequestMethod.POST)
    InvoiceBatchNosQueryByConditionResponse queryInvoiceBatchNos(InvoiceBatchNosQueryByConditionRequest invoiceBatchNosQueryByConditionRequest);

    @ApiOperation(value = "发票列表查询-按批次号", notes = "", response = SellerInvoiceQueryByBatchNoResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SellerInvoiceQueryByBatchNoResponse.class) })
    @RequestMapping(value = "/invoice/queryInvoicesByBatchNo",
            produces = { "application/json" },
            method = RequestMethod.POST)
    SellerInvoiceQueryByBatchNoResponse queryInvoicesByBatchNo(@ApiParam(value = "发票查询请求") @RequestBody SellerInvoiceQueryByBatchNoRequest sellerInvoiceQueryByBatchNoRequest);


    @ApiOperation(value = "发票 - 查看一个批次号下所有操作日志", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/showInvoiceHistoryByBatchNo",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response showInvoiceHistoryByBatchNo(@ApiParam(value = "查看历史日志", required = true) @RequestBody ShowInvoiceHistoryByBatchNoRequest showInvoiceHistoryByBatchNoRequest);

    @ApiOperation(value = "统计在线开票数量", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/queryOnlineSum",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response queryOnlineSumRequest(@ApiParam(value = "查询在线开票数量", required = true) @RequestBody QueryOnlineSumRequest queryOnlineSumRequest);


    @ApiOperation(value = "申请红字信息表编号", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/applyRedInfoNoForInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response applyRedInfoNoForInvoice(@ApiParam(value = "发票申请红字信息表编号请求", required = true) @RequestBody ApplyRedNotificationRequest applyRedNotifucationRequest);


    @ApiOperation(value = "查询物流跟踪信息",authorizations = {
            @Authorization(value = "x-access-token")
    })
    @RequestMapping(value = "/invoice/logistics/track",produces = { "application/json" },
            method = RequestMethod.POST)
    Response queryLogistics(@RequestBody LogisticsTrackRequest logisticsTrackReq);

    @ApiOperation(value = "查询开票结果", notes = "", response = QueryMakeOutResultResponse.class,
            authorizations = {@Authorization("x-access-token"), @Authorization("x-operation-token")},
            tags = {"InvoiceOperation"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = QueryMakeOutResultResponse.class) })
    @RequestMapping(value = "/query-makeout-result",
            produces = {"application/json"},
            method = RequestMethod.POST)
    QueryMakeOutResultResponse queryMakeOutResult(@ApiParam(value = "操作请求参数", required = true) @RequestBody QueryMakeOutResultRequest makeOutResultRequest);

    @ApiOperation(value = "查询开票结果并解锁预制发票", notes = "", response = Response.class,
            authorizations = {@Authorization("x-access-token"), @Authorization("x-operation-token")},
            tags = {"InvoiceOperation"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/query-makeout-result-unlock",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response queryAndUnlockFromPid(@ApiParam(value = "操作请求参数", required = true) @RequestBody Long pid);

    @ApiOperation(value = "更新发票匹配的业务单id和业务单号", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/updateInvoiceSales",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response updateInvoiceSales(@ApiParam(value = "请求参数", required = true) @RequestBody ModifyInvoiceBySalesRequest modifyInvoiceBySalesRequest);

    @ApiOperation(value = "匹配单据后的发票信息补全", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/completeInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response completeDrawInvoices(@ApiParam(value = "请求参数", required = true) @RequestBody CompleteDrawInvoiceRequest request);

    @ApiOperation(value = "锁定单据与发票的关系", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/lockBillInvoiceMatchedRelation",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response lockBillInvoiceMatchedRelation(@ApiParam(value = "请求参数", required = true) @RequestBody BillInvoiceLockMatchedRelationRequest billInvoiceLockMatchedRelationRequest);

    @ApiOperation(value = "解除锁定单据与发票的关系", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/unLockBillInvoiceMatchedRelation",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response unLockBillInvoiceMatchedRelation(@ApiParam(value = "请求参数", required = true) @RequestBody BillInvoiceLockMatchedRelationRequest billInvoiceUnLockMatchedRelationRequest);

    @ApiOperation(value = "查询发票", notes = "", response = Response.class,
            authorizations = {@Authorization("x-access-token"), @Authorization("x-operation-token")},
            tags = {"InvoiceOperation"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/queryInvoiceInfo",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response queryInvoiceInfo(@ApiParam(value = "操作请求参数", required = true) @RequestBody QueryInvoiceInfoReuqest request);

    @ApiOperation(value = "发票详情-业务单匹配发票时用", notes = "", response = InvoiceItemsResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "发票详情返回", response = InvoiceItemsResponse.class) })
    @RequestMapping(value = "/invoice/batch-query-invoice-items",
            produces = { "application/json" },
            method = RequestMethod.POST)
    InvoiceItemsResponse queryInvoiceItemsById(@ApiParam(value = "发票id", required = true) @RequestBody QuerySellerInvoiceItemsRequest querySellerInvoiceItemsRequest);

    @ApiOperation(value = "搜索可以红冲的发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/searchInvoiceIdsWhichCanRedFlush",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response searchInvoiceIdsWhichCanRedFlush(@ApiParam(value = "请求参数", required = true) @RequestBody List<Long> invoiceIds);

    @ApiOperation(value = "统计同一批次号下发票数量", notes = "", response = InvoiceBatchNoInfoResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = InvoiceBatchNoInfoResponse.class) })
    @RequestMapping(value = "/invoice/countInvoicesByBatchNo",
            produces = { "application/json" },
            method = RequestMethod.POST)
    InvoiceBatchNoInfoResponse countInvoicesByBatchNoRequest(@ApiParam(value = "批次号request", required = true) @RequestBody QueryInvoiceBatchNoInfoRequest queryInvoiceBatchNoInfoRequest);

    @ApiOperation(value = "退票申请", notes = "", response = Response.class,
            authorizations = {@Authorization("x-access-token"), @Authorization("x-operation-token")},
            tags = {"InvoiceOperation"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/applyRefundByInvoiceNo",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response invoiceApplyRefundByInvoiceNo(@ApiParam(value = "操作请求参数", required = true) @RequestBody MsApplyRefundByInvoiceNoRequest request);


    //冗余批量查询发票信息方法
    @ApiOperation(value = "查询发票", notes = "", response = Response.class,
            authorizations = {@Authorization("x-access-token"), @Authorization("x-operation-token")},
            tags = {"InvoiceOperation"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/queryInvoices",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response queryInvoices(@ApiParam(value = "操作请求参数", required = true) @RequestBody QueryInvoicesReuqest request);


    @ApiOperation(value = "单张发票发送邮件", notes = "", response = Response.class,
            authorizations = {@Authorization("x-access-token"), @Authorization("x-operation-token")},
            tags = {"InvoiceOperation"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/invoice/sendEmailByInvoiceNo",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response sendEmailByInvoiceNo(@ApiParam(value = "操作请求参数", required = true) @RequestBody SendEmailByInvoiceNoRequest request);

    @ApiOperation(value = "查询发票明细（普通明细和机动车）", response = InvoiceDetailsInfoResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "发票详情返回", response = InvoiceDetailsInfoResponse.class) })
    @RequestMapping(value = "/invoice/query-detail",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response<InvoiceDetailReply> queryInvoiceDetailsById(@RequestBody DetailQueryRequest request);

    @ApiOperation(value = "发票批量红冲作废预检接口", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "发票详情返回", response = Response.class) })
    @RequestMapping(value = "/invoice/abandon-and-reverse/check",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response<List<BatchAbandonReverseReply>> batchAbandonAndReverseCheck(@RequestBody BatchAbandonReverseCheckRequest request);

    @ApiOperation(value = "发票批量红冲作废", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "发票详情返回", response = Response.class) })
    @RequestMapping(value = "/invoice/abandon-and-reverse",
            produces = { "application/json" },
            method = RequestMethod.POST)
    BaseAsyncResponse batchAbandonAndReverse(@RequestBody BatchAbandonReverseRequest request);

    @ApiOperation(value = "销协融合-发票详情(包含发票信息、发票明细信息列表、机动车信息)", notes = "", response = InvoiceDetailsInfoResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "发票详情返回", response = InvoiceDetailsInfoResponse.class) })
    @RequestMapping(value = "/invoice/query-by-condition",
            produces = { "application/json" },
            method = RequestMethod.POST)
    InvoiceDetailsInfoResponse queryInvoiceByCondition(@ApiParam(value = "发票查询请求", required = true) @RequestBody QuerySellerInvoiceDetailsRequest querySellerInvoiceDetailsRequest);

    @ApiOperation(value = "销协融合-批量查询发票详情(包含发票信息、发票明细信息列表、机动车信息)", notes = "", response = QueryInvoiceWithDetailsResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "发票详情返回", response = QueryInvoiceWithDetailsResponse.class) })
    @RequestMapping(value = "/invoice/queryInvoiceWithDetailsList",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response queryInvoiceWithDetailsList(@ApiParam(value = "发票查询请求", required = true) @RequestBody QueryInvoicesReuqest queryInvoiceWithDetailsRequest);


    @ApiOperation(value = "发票批量红冲", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "发票详情返回", response = Response.class) })
    @RequestMapping(value = "/invoice/batch/reverse",
            produces = { "application/json" },
            method = RequestMethod.POST)
    BaseAsyncResponse batchReverse(@RequestBody BatchReverseRequest request);

    @ApiOperation(value = "发票线下红冲（单张）", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "发票线下红冲返回", response = Response.class) })
    @RequestMapping(value = "/invoice/reverse-offline",
            produces = { "application/json" },
            method = RequestMethod.POST)
    BaseAsyncResponse reverseOffline(@RequestBody RedFlushInvoiceNoDirectRequest request);

    @ApiOperation(value = "发票查询-康帕斯协同报表数据支持", notes = "", response = SellerInvoiceQueryResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SellerInvoiceQueryResponse.class) })
    @RequestMapping(value = "/invoice/compass/queryInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response<DataListResult<QuerySellerInvoice>> queryCompassInvoice(@RequestBody QueryCompassInvoiceReuqest request);

    @ApiOperation(value = "发票查询-智能匹配发票查询", notes = "", response = SmartMatchInvoiceResult.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerInvoice", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "统一返回", response = SmartMatchInvoiceResult.class) })
    @RequestMapping(value = "/invoice/smart/match/invoice",
        produces = { "application/json" },
        method = RequestMethod.POST)
    Response<SmartMatchInvoiceResult> smartMatchingInvoice(@ApiParam(value = "智能匹配发票查询请求", required = true) @RequestBody SmartMatchInvoiceRequest smartMatchInvoiceRequest);

    @ApiOperation(value = "发票作废 - 轮训结果接口", response = PollingAbandonInvoiceResultResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerInvoice",})
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "统一返回", response = PollingAbandonInvoiceResultResponse.class)})
    @RequestMapping(value = "/invoice/pollingAbandonInvoiceResult",
        produces = {"application/json"},
        method = RequestMethod.POST)
    Response<PollingAbandonInvoiceResult> pollingAbandonInvoiceResult(@ApiParam(value = "轮询通用请求（任务id）", required = true) @RequestBody PollingBaseRequest pollingBaseRequest);
}
