package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.AutoGeneratePDF4Request;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value = "invoiceAutoPdf", description = "the PDF for automations task API")
public interface InvoiceAutoPdfApi {

	@ApiOperation(value = "纸票自动生成pdf", notes = "", response = Response.class, authorizations = {
			@Authorization(value = "X-Access-Token"),
			@Authorization(value = "X-Operation-Token") }, tags = { "SellerInvoiceAutoPdf", })
	@ApiResponses(value = { @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
	@RequestMapping(value = "/autoGeneratePdf", produces = {
			MediaType.APPLICATION_JSON_UTF8_VALUE }, method = RequestMethod.POST)
	Response autoGeneratePdf(@ApiParam("纸票自动生成pdf") @RequestBody AutoGeneratePDF4Request request);
}
