package com.xforceplus.seller.invoice.client.api;

import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.xforceplus.seller.invoice.client.model.MsLogisticsDataRequest;
import com.xforceplus.xplatframework.model.Response;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;

@Api(value = "invoiceLogistics", description = "the invoiceLogistics API")
public interface InvoiceLogisticsApi {

	@ApiOperation(value = "推送发票数据", notes = "", response = Response.class, authorizations = {
			@Authorization(value = "X-Access-Token"),
			@Authorization(value = "X-Operation-Token") }, tags = { "SellerInvoiceLogistics", })
	@ApiResponses(value = { @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
	@RequestMapping(value = "/pushInvoiceData", produces = {
			MediaType.APPLICATION_JSON_UTF8_VALUE }, method = RequestMethod.POST)
	Response pushInvoiceData(@RequestBody MsLogisticsDataRequest request);
}
