package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.*;

import com.xforceplus.seller.invoice.clientl.v2.request.QueryMakeOutResultRequest;
import com.xforceplus.seller.invoice.clientl.v2.response.QueryMakeOutResultResponse;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 项目名称:
 * 模块名称:
 * 说明: 业务系统
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/4/23 15:26
 */
@Api(value = "Invoice Operation", description = "业务系统发起发票操作")
public interface InvoiceOperationApi {

    @ApiOperation(value = "发票退回/红冲/作废", notes = "", response = InvoiceOperationResponse.class,
            authorizations = {@Authorization("x-access-token"), @Authorization("x-operation-token")},
            tags = {"InvoiceOperation"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = InvoiceOperationResponse.class) })
    @RequestMapping(value = "/red-or-abandon",
            produces = {"application/json"},
            method = RequestMethod.POST)
    InvoiceOperationResponse redOrAbandonInvoice(@ApiParam(value = "操作请求参数", required = true) @RequestBody InvoiceOperationRequest operationRequest);

    @ApiOperation(value = "发票退回/红冲/作废取消", notes = "", response = InvoiceOperationCancelResponse.class,
            authorizations = {@Authorization("x-access-token"), @Authorization("x-operation-token")},
            tags = {"InvoiceOperation"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = InvoiceOperationCancelResponse.class) })
    @RequestMapping(value = "/cancel-red-or-abandon",
            produces = {"application/json"},
            method = RequestMethod.POST)
    InvoiceOperationCancelResponse cancelRedOrAbandonInvoice(@ApiParam(value = "退回取消操作请求参数", required = true) @RequestBody InvoiceOperationCancelRequest operationCancelRequest);

    @ApiOperation(value = "发票明细更新", notes = "", response = Response.class,
            authorizations = {@Authorization("x-access-token"), @Authorization("x-operation-token")},
            tags = {"InvoiceOperation"})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/update/details",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response updateInvoiceItem(@ApiParam(value = "退回取消操作请求参数", required = true) @RequestBody UpdateInvoiceDetailRequest request);


}