package com.xforceplus.seller.invoice.client.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 数电纸票打印 客户端契约对象
 * 客户端契约：https://xforceplus.yuque.com/dew9bm/aqd8pk/gkh9ti20srh5mgcq#Vfpt3
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class AllElectricPaperPrintForClientVo implements Serializable {

    //流水号
    private String serialNo = null;
    //是否销货清单标志	true销货清单 false发票
    private Boolean saleListFlag = null;
    //发票类型 cz:数电普纸 sz :数电专纸
    private String invoiceType = null;
    //备注
    private String remark = null;
    //特定要素类型代码
    private String invoiceStyleType = null;
    //红字确认单编号
    private String redNotificationNo = null;
    //数电发票号码
    private String qInvoiceNo = null;
    //全国增值税发票查验平台		比如：https://inv-veri.chinatax.gov.cn/
    private String qCheckPlatform = null;
    //发票号码
    private String InvoiceNo = null;
    //发票代码
    private String InvoiceCode = null;
    //发票日期 yyyy-MM-dd hh:mm:ss
    private String InvoiceDate = null;
    //返回结果的队列名 需要区分测试和生产队列
    private String resultQueueName = null;
    //销方信息
    private Seller seller = null;
    //购方信息
    private Purchaser purchaser = null;
    //操作人信息
    private Operator operator = null;
    //发票金额信息
    private InvoiceAmount invoiceAmount = null;
    //数电特殊业务（成品油、货物运输等）：https://xforceplus.yuque.com/dew9bm/yagacb/fhcho3v7sw9p3eil
    private List<Map<String, Object>> extra = null;
    //明细列表
    private List<Detail> detailList = null;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Seller implements Serializable {
        //销方名称
        private String sellerName = null;
        //销方税号
        private String sellerTaxCode = null;
        //销方地址
        private String sellerAddress = null;
        //销方电话
        private String sellerTelNo = null;
        //销方开户行
        private String sellerBank = null;
        //销方开户行账号
        private String sellerBankAccount = null;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Purchaser implements Serializable {
        //购方名称
        private String purchaserName = null;
        //购方税号
        private String purchaserTaxCode = null;
        //购方地址
        private String purchaserAddress = null;
        //购方电话
        private String purchaserTelNo = null;
        //购方开户行
        private String purchaserBank = null;
        //购方开户行账号
        private String purchaserBankAccount = null;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Operator implements Serializable {
        //开票人
        private String drawerName = null;
        //收款人
        private String cashierName = null;
        //复核人
        private String checkerName = null;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class InvoiceAmount implements Serializable {
        //合计金额 float
        private BigDecimal amountWithoutTax = null;
        //价税合计 float
        private BigDecimal amountWithTax = null;
        //合计税额 float
        private BigDecimal taxAmount = null;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Detail implements Serializable {
        //明细行类型 0-正常行  1-折扣行（负数） 2-被折扣行（正数）
        private Integer detailType = null;
        //明细金额(不含税金额) float
        private BigDecimal detailAmount = null;
        //数量 float 销货清单不传该字段
        private BigDecimal quantity = null;
        //不含税单价 float 销货清单不传该字段
        private BigDecimal unitPrice = null;
        //税额 float
        private BigDecimal taxAmount= null;
        //商品名称 打印清单发票时固定名称：红冲清单发票-详见对应正数发票及清单 蓝字清单发票-（详见对应销货清单）
        //带上简称，如：*润滑油*壳牌/Shell 超凡喜力 新升级高效动力版全合成润滑油 U
        private String productionName = null;
        //规格型号
        private String specification = null;
        //单位
        private String unitName = null;
        //税率	打印发票时 ：所有明细税率相同传税率，否则多税率的传空值；(销货清单多税率)
        private BigDecimal taxRate = null;
        //税编
        private String taxClassCode = null;
        //优惠政策类型 https://xforceplus.yuque.com/dew9bm/yagacb/gbidri#I3mhd
        private String taxIncentivesType= null;
    }
}
