package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class BatchAbandonReverseReply {
    @ApiModelProperty("发票id")
    private String invoiceId;
    @ApiModelProperty("发票号码")
    private String invoiceNo;
    @ApiModelProperty("发票代码")
    private String invoiceCode;
    @ApiModelProperty("购方名称")
    private String purchaserName;
    @ApiModelProperty("发票类型")
    private String invoiceType;
    @ApiModelProperty("含税金额")
    private BigDecimal amountWithTax;
    @ApiModelProperty("操作类型")
    private Integer operationType;
    @ApiModelProperty("国税发票来源")
    private String taxInvoiceSource;
    @ApiModelProperty("红字信息表/红字确认单编号")
    private String redLetterNumber;
    @ApiModelProperty("红字确认单状态")
    private String redLetterStatus;
    @ApiModelProperty("轮询任务id，有轮询中任务时返回")
    private String taskId;
    @ApiModelProperty("特殊发票标识")
    private String specialInvoiceFlag;
}
