package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制发票对应单据主信息
 */
@ApiModel(description = "预制发票对应单据主信息")

@JsonInclude(NON_NULL)
public class BillOfPreInvoiceMain {
  @JsonProperty("salesbillId")
  private String salesbillId = null;

  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("salesbillType")
  private String salesbillType = null;

  @JsonProperty("sellerNo")
  private String sellerNo = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerTel")
  private String sellerTel = null;

  @JsonProperty("sellerAddress")
  private String sellerAddress = null;

  @JsonProperty("sellerBankName")
  private String sellerBankName = null;

  @JsonProperty("sellerBankAccount")
  private String sellerBankAccount = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaserNo")
  private String purchaserNo = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserTel")
  private String purchaserTel = null;

  @JsonProperty("purchaserAddress")
  private String purchaserAddress = null;

  @JsonProperty("purchaserBankName")
  private String purchaserBankName = null;

  @JsonProperty("purchaserBankAccount")
  private String purchaserBankAccount = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("amountWithTax")
  private BigDecimal amountWithTax = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("outterDiscountWithTax")
  private BigDecimal outterDiscountWithTax = null;

  @JsonProperty("outterDiscountWithoutTax")
  private BigDecimal outterDiscountWithoutTax = null;

  @JsonProperty("innerDiscountWithTax")
  private BigDecimal innerDiscountWithTax = null;

  @JsonProperty("innerDiscountWithoutTax")
  private BigDecimal innerDiscountWithoutTax = null;

  @JsonProperty("outterPrepayAmountWithTax")
  private BigDecimal outterPrepayAmountWithTax = null;

  @JsonProperty("outterPrepayAmountWithoutTax")
  private BigDecimal outterPrepayAmountWithoutTax = null;

  @JsonProperty("innerPrepayAmountWithTax")
  private BigDecimal innerPrepayAmountWithTax = null;

  @JsonProperty("innerPrepayAmountWithoutTax")
  private BigDecimal innerPrepayAmountWithoutTax = null;

  @JsonIgnore
  public BillOfPreInvoiceMain salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

   /**
   * 单据号
   * @return salesbillNo
  **/
  @ApiModelProperty(value = "单据号")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain salesbillId(String salesbillId) {
    this.salesbillId = salesbillId;
    return this;
  }

  /**
   * 单据号
   * @return salesbillNo
   **/
  @ApiModelProperty(value = "单据号")
  public String getSalesbillId() {
    return salesbillId;
  }

  public void setSalesbillId(String salesbillId) {
    this.salesbillId = salesbillId;
  }


  @JsonIgnore
  public BillOfPreInvoiceMain salesbillType(String salesbillType) {
    this.salesbillType = salesbillType;
    return this;
  }

   /**
   * 单据类型
   * @return salesbillType
  **/
  @ApiModelProperty(value = "单据类型")
  public String getSalesbillType() {
    return salesbillType;
  }

  public void setSalesbillType(String salesbillType) {
    this.salesbillType = salesbillType;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain sellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
    return this;
  }

   /**
   * 销方租户公司编号
   * @return sellerNo
  **/
  @ApiModelProperty(value = "销方租户公司编号")
  public String getSellerNo() {
    return sellerNo;
  }

  public void setSellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方纳税人识别号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方纳税人识别号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain sellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
    return this;
  }

   /**
   * 销方电话
   * @return sellerTel
  **/
  @ApiModelProperty(value = "销方电话")
  public String getSellerTel() {
    return sellerTel;
  }

  public void setSellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain sellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
    return this;
  }

   /**
   * 销方地址
   * @return sellerAddress
  **/
  @ApiModelProperty(value = "销方地址")
  public String getSellerAddress() {
    return sellerAddress;
  }

  public void setSellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain sellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
    return this;
  }

   /**
   * 销方银行名称
   * @return sellerBankName
  **/
  @ApiModelProperty(value = "销方银行名称")
  public String getSellerBankName() {
    return sellerBankName;
  }

  public void setSellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain sellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
    return this;
  }

   /**
   * 销方银行账号
   * @return sellerBankAccount
  **/
  @ApiModelProperty(value = "销方银行账号")
  public String getSellerBankAccount() {
    return sellerBankAccount;
  }

  public void setSellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain purchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
    return this;
  }

   /**
   * 购方租户公司编号
   * @return purchaserNo
  **/
  @ApiModelProperty(value = "购方租户公司编号")
  public String getPurchaserNo() {
    return purchaserNo;
  }

  public void setPurchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方纳税人识别号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方纳税人识别号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain purchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
    return this;
  }

   /**
   * 购方电话
   * @return purchaserTel
  **/
  @ApiModelProperty(value = "购方电话")
  public String getPurchaserTel() {
    return purchaserTel;
  }

  public void setPurchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain purchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
    return this;
  }

   /**
   * 购方地址
   * @return purchaserAddress
  **/
  @ApiModelProperty(value = "购方地址")
  public String getPurchaserAddress() {
    return purchaserAddress;
  }

  public void setPurchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain purchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
    return this;
  }

   /**
   * 购方银行名称
   * @return purchaserBankName
  **/
  @ApiModelProperty(value = "购方银行名称")
  public String getPurchaserBankName() {
    return purchaserBankName;
  }

  public void setPurchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain purchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
    return this;
  }

   /**
   * 购方银行账号
   * @return purchaserBankAccount
  **/
  @ApiModelProperty(value = "购方银行账号")
  public String getPurchaserBankAccount() {
    return purchaserBankAccount;
  }

  public void setPurchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain amountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public BigDecimal getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain amountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain outterDiscountWithTax(BigDecimal outterDiscountWithTax) {
    this.outterDiscountWithTax = outterDiscountWithTax;
    return this;
  }

   /**
   * 价外含税折扣
   * @return outterDiscountWithTax
  **/
  @ApiModelProperty(value = "价外含税折扣")
  public BigDecimal getOutterDiscountWithTax() {
    return outterDiscountWithTax;
  }

  public void setOutterDiscountWithTax(BigDecimal outterDiscountWithTax) {
    this.outterDiscountWithTax = outterDiscountWithTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain outterDiscountWithoutTax(BigDecimal outterDiscountWithoutTax) {
    this.outterDiscountWithoutTax = outterDiscountWithoutTax;
    return this;
  }

   /**
   * 价外不含税折扣
   * @return outterDiscountWithoutTax
  **/
  @ApiModelProperty(value = "价外不含税折扣")
  public BigDecimal getOutterDiscountWithoutTax() {
    return outterDiscountWithoutTax;
  }

  public void setOutterDiscountWithoutTax(BigDecimal outterDiscountWithoutTax) {
    this.outterDiscountWithoutTax = outterDiscountWithoutTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain innerDiscountWithTax(BigDecimal innerDiscountWithTax) {
    this.innerDiscountWithTax = innerDiscountWithTax;
    return this;
  }

   /**
   * 价内含税折扣
   * @return innerDiscountWithTax
  **/
  @ApiModelProperty(value = "价内含税折扣")
  public BigDecimal getInnerDiscountWithTax() {
    return innerDiscountWithTax;
  }

  public void setInnerDiscountWithTax(BigDecimal innerDiscountWithTax) {
    this.innerDiscountWithTax = innerDiscountWithTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain innerDiscountWithoutTax(BigDecimal innerDiscountWithoutTax) {
    this.innerDiscountWithoutTax = innerDiscountWithoutTax;
    return this;
  }

   /**
   * 价内不含税折扣
   * @return innerDiscountWithoutTax
  **/
  @ApiModelProperty(value = "价内不含税折扣")
  public BigDecimal getInnerDiscountWithoutTax() {
    return innerDiscountWithoutTax;
  }

  public void setInnerDiscountWithoutTax(BigDecimal innerDiscountWithoutTax) {
    this.innerDiscountWithoutTax = innerDiscountWithoutTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain outterPrepayAmountWithTax(BigDecimal outterPrepayAmountWithTax) {
    this.outterPrepayAmountWithTax = outterPrepayAmountWithTax;
    return this;
  }

   /**
   * 价外预付卡含税金额
   * @return outterPrepayAmountWithTax
  **/
  @ApiModelProperty(value = "价外预付卡含税金额")
  public BigDecimal getOutterPrepayAmountWithTax() {
    return outterPrepayAmountWithTax;
  }

  public void setOutterPrepayAmountWithTax(BigDecimal outterPrepayAmountWithTax) {
    this.outterPrepayAmountWithTax = outterPrepayAmountWithTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain outterPrepayAmountWithoutTax(BigDecimal outterPrepayAmountWithoutTax) {
    this.outterPrepayAmountWithoutTax = outterPrepayAmountWithoutTax;
    return this;
  }

   /**
   * 价外预付卡不含税金额
   * @return outterPrepayAmountWithoutTax
  **/
  @ApiModelProperty(value = "价外预付卡不含税金额")
  public BigDecimal getOutterPrepayAmountWithoutTax() {
    return outterPrepayAmountWithoutTax;
  }

  public void setOutterPrepayAmountWithoutTax(BigDecimal outterPrepayAmountWithoutTax) {
    this.outterPrepayAmountWithoutTax = outterPrepayAmountWithoutTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain innerPrepayAmountWithTax(BigDecimal innerPrepayAmountWithTax) {
    this.innerPrepayAmountWithTax = innerPrepayAmountWithTax;
    return this;
  }

   /**
   * 价内预付卡含税金额
   * @return innerPrepayAmountWithTax
  **/
  @ApiModelProperty(value = "价内预付卡含税金额")
  public BigDecimal getInnerPrepayAmountWithTax() {
    return innerPrepayAmountWithTax;
  }

  public void setInnerPrepayAmountWithTax(BigDecimal innerPrepayAmountWithTax) {
    this.innerPrepayAmountWithTax = innerPrepayAmountWithTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceMain innerPrepayAmountWithoutTax(BigDecimal innerPrepayAmountWithoutTax) {
    this.innerPrepayAmountWithoutTax = innerPrepayAmountWithoutTax;
    return this;
  }

   /**
   * 价内预付卡不含税金额
   * @return innerPrepayAmountWithoutTax
  **/
  @ApiModelProperty(value = "价内预付卡不含税金额")
  public BigDecimal getInnerPrepayAmountWithoutTax() {
    return innerPrepayAmountWithoutTax;
  }

  public void setInnerPrepayAmountWithoutTax(BigDecimal innerPrepayAmountWithoutTax) {
    this.innerPrepayAmountWithoutTax = innerPrepayAmountWithoutTax;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BillOfPreInvoiceMain billOfPreInvoiceMain = (BillOfPreInvoiceMain) o;
    return Objects.equals(this.salesbillId, billOfPreInvoiceMain.salesbillId) &&
        Objects.equals(this.salesbillNo, billOfPreInvoiceMain.salesbillNo) &&
        Objects.equals(this.salesbillType, billOfPreInvoiceMain.salesbillType) &&
        Objects.equals(this.sellerNo, billOfPreInvoiceMain.sellerNo) &&
        Objects.equals(this.sellerName, billOfPreInvoiceMain.sellerName) &&
        Objects.equals(this.sellerTaxNo, billOfPreInvoiceMain.sellerTaxNo) &&
        Objects.equals(this.sellerTel, billOfPreInvoiceMain.sellerTel) &&
        Objects.equals(this.sellerAddress, billOfPreInvoiceMain.sellerAddress) &&
        Objects.equals(this.sellerBankName, billOfPreInvoiceMain.sellerBankName) &&
        Objects.equals(this.sellerBankAccount, billOfPreInvoiceMain.sellerBankAccount) &&
        Objects.equals(this.purchaserName, billOfPreInvoiceMain.purchaserName) &&
        Objects.equals(this.purchaserNo, billOfPreInvoiceMain.purchaserNo) &&
        Objects.equals(this.purchaserTaxNo, billOfPreInvoiceMain.purchaserTaxNo) &&
        Objects.equals(this.purchaserTel, billOfPreInvoiceMain.purchaserTel) &&
        Objects.equals(this.purchaserAddress, billOfPreInvoiceMain.purchaserAddress) &&
        Objects.equals(this.purchaserBankName, billOfPreInvoiceMain.purchaserBankName) &&
        Objects.equals(this.purchaserBankAccount, billOfPreInvoiceMain.purchaserBankAccount) &&
        Objects.equals(this.invoiceType, billOfPreInvoiceMain.invoiceType) &&
        Objects.equals(this.amountWithTax, billOfPreInvoiceMain.amountWithTax) &&
        Objects.equals(this.amountWithoutTax, billOfPreInvoiceMain.amountWithoutTax) &&
        Objects.equals(this.taxAmount, billOfPreInvoiceMain.taxAmount) &&
        Objects.equals(this.outterDiscountWithTax, billOfPreInvoiceMain.outterDiscountWithTax) &&
        Objects.equals(this.outterDiscountWithoutTax, billOfPreInvoiceMain.outterDiscountWithoutTax) &&
        Objects.equals(this.innerDiscountWithTax, billOfPreInvoiceMain.innerDiscountWithTax) &&
        Objects.equals(this.innerDiscountWithoutTax, billOfPreInvoiceMain.innerDiscountWithoutTax) &&
        Objects.equals(this.outterPrepayAmountWithTax, billOfPreInvoiceMain.outterPrepayAmountWithTax) &&
        Objects.equals(this.outterPrepayAmountWithoutTax, billOfPreInvoiceMain.outterPrepayAmountWithoutTax) &&
        Objects.equals(this.innerPrepayAmountWithTax, billOfPreInvoiceMain.innerPrepayAmountWithTax) &&
        Objects.equals(this.innerPrepayAmountWithoutTax, billOfPreInvoiceMain.innerPrepayAmountWithoutTax);
  }

  @Override
  public int hashCode() {
    return Objects.hash(salesbillId,salesbillNo, salesbillType, sellerNo, sellerName, sellerTaxNo, sellerTel, sellerAddress, sellerBankName, sellerBankAccount, purchaserName, purchaserNo, purchaserTaxNo, purchaserTel, purchaserAddress, purchaserBankName, purchaserBankAccount, invoiceType, amountWithTax, amountWithoutTax, taxAmount, outterDiscountWithTax, outterDiscountWithoutTax, innerDiscountWithTax, innerDiscountWithoutTax, outterPrepayAmountWithTax, outterPrepayAmountWithoutTax, innerPrepayAmountWithTax, innerPrepayAmountWithoutTax);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BillOfPreInvoiceMain {\n");
    sb.append("    salesbillId: ").append(toIndentedString(salesbillId)).append("\n");
    sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
    sb.append("    salesbillType: ").append(toIndentedString(salesbillType)).append("\n");
    sb.append("    sellerNo: ").append(toIndentedString(sellerNo)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    sellerTel: ").append(toIndentedString(sellerTel)).append("\n");
    sb.append("    sellerAddress: ").append(toIndentedString(sellerAddress)).append("\n");
    sb.append("    sellerBankName: ").append(toIndentedString(sellerBankName)).append("\n");
    sb.append("    sellerBankAccount: ").append(toIndentedString(sellerBankAccount)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    purchaserNo: ").append(toIndentedString(purchaserNo)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    purchaserTel: ").append(toIndentedString(purchaserTel)).append("\n");
    sb.append("    purchaserAddress: ").append(toIndentedString(purchaserAddress)).append("\n");
    sb.append("    purchaserBankName: ").append(toIndentedString(purchaserBankName)).append("\n");
    sb.append("    purchaserBankAccount: ").append(toIndentedString(purchaserBankAccount)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    outterDiscountWithTax: ").append(toIndentedString(outterDiscountWithTax)).append("\n");
    sb.append("    outterDiscountWithoutTax: ").append(toIndentedString(outterDiscountWithoutTax)).append("\n");
    sb.append("    innerDiscountWithTax: ").append(toIndentedString(innerDiscountWithTax)).append("\n");
    sb.append("    innerDiscountWithoutTax: ").append(toIndentedString(innerDiscountWithoutTax)).append("\n");
    sb.append("    outterPrepayAmountWithTax: ").append(toIndentedString(outterPrepayAmountWithTax)).append("\n");
    sb.append("    outterPrepayAmountWithoutTax: ").append(toIndentedString(outterPrepayAmountWithoutTax)).append("\n");
    sb.append("    innerPrepayAmountWithTax: ").append(toIndentedString(innerPrepayAmountWithTax)).append("\n");
    sb.append("    innerPrepayAmountWithoutTax: ").append(toIndentedString(innerPrepayAmountWithoutTax)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
