package com.xforceplus.seller.invoice.client.model;

import java.util.stream.Stream;

/**
 * 单据拆票&开具链路监控事件枚举定义
 */
public enum BillSplitedIssueMonitorEventEnum {

    /**
     * 单据向中台发起拆票请求事件
     */
    BILL_SPLIT_REQUEST_TO_MIDDLE("bill_split_request_to_middle","单据向中台发起拆票请求事件"),

    /**
     * 中台返回拆票结果事件
     */
    BILL_SPLIT_RESPONSE_FROM_MIDDLE("bill_split_response_from_middle","中台返回拆票结果事件"),

    /**
     * 红字确认单申请请求到税件事件
     */
    RED_CONFIRMATION_APPLY_REQUEST_TO_TAX("red_confirmation_apply_request_to_tax","红字确认单申请请求到税件事件"),

    /**
     * 红字确认单申请请求到税件
     */
    RED_CONFIRMATION_APPLY_RESONSE_FROM_TAX("red_confirmation_apply_response_from_tax","红字确认单申请请求到税件"),

    /**
     * 发起终端查询请求到税件事件
     */
    TERMINAL_QUERY_REQUEST_TO_TAX("terminal_query_request_to_tax","发起终端查询请求到税件事件"),

    /**
     * 税件返回终端查询结果事件
     */
    TERMINAL_QUERY_RESPONSE_FROM_TAX("terminal_query_response_from_tax","税件返回终端查询结果事件"),

    /**
     * 发起开具请求到税件事件
     */
    INVOICE_ISSUE_REQUEST_TO_TAX("invoice_issue_request_to_tax","发起开具请求到税件事件"),

    /**
     * 税件返回开具结果事件
     */
    INVOICE_ISSUE_RESPONSE_FROM_TAX("invoice_issue_result_from_tax","税件返回开具结果事件");

    private final String code;

    private final String description;

    BillSplitedIssueMonitorEventEnum(String code, String desc)
    {
        this.code = code;
        this.description = desc;
    }

    public String value()
    {
        return  this.code;
    }

    public String description(){return this.description;}

    public static BillSplitedIssueMonitorEventEnum from(String value){
       return Stream.of(BillSplitedIssueMonitorEventEnum.values())
               .filter(r -> r.value().equals(value))
               .findFirst().orElse(null);
    }
}
