package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 货物运输明细数据
 */
@ApiModel(description = "货物运输明细数据")

@JsonInclude(NON_NULL)
public class CargoTransportSpecialAddition {
  @JsonProperty("itemId")
  private Long itemId = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;
  /**
   * 订单明细号
   */
  @JsonProperty("salesbillItemNo")
  private String salesbillItemNo = null;

  // 货物运输服务
  //运输工具种类
  @JsonProperty("toolType")
  private String toolType = null;

  //运输工具牌号
  @JsonProperty("toolBrand")
  private String toolBrand = null;

  //运输货物名称
  @JsonProperty("nameOfGoods")
  private String nameOfGoods = null;

  //起运地
  @JsonProperty("placeOfShipment")
  private String placeOfShipment = null;

  //到达地
  @JsonProperty("destination")
  private String destination = null;

  public Long getItemId() {
    return itemId;
  }

  public void setItemId(Long itemId) {
    this.itemId = itemId;
  }

  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  public String getToolType() {
    return toolType;
  }

  public void setToolType(String toolType) {
    this.toolType = toolType;
  }

  public String getToolBrand() {
    return toolBrand;
  }

  public void setToolBrand(String toolBrand) {
    this.toolBrand = toolBrand;
  }

  public String getNameOfGoods() {
    return nameOfGoods;
  }

  public void setNameOfGoods(String nameOfGoods) {
    this.nameOfGoods = nameOfGoods;
  }

  public String getPlaceOfShipment() {
    return placeOfShipment;
  }

  public void setPlaceOfShipment(String placeOfShipment) {
    this.placeOfShipment = placeOfShipment;
  }

  public String getDestination() {
    return destination;
  }

  public void setDestination(String destination) {
    this.destination = destination;
  }

  public String getSalesbillItemNo() {
    return salesbillItemNo;
  }

  public void setSalesbillItemNo(String salesbillItemNo) {
    this.salesbillItemNo = salesbillItemNo;
  }
}
