package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制删除发票请求参数
 */
@ApiModel(description = "预制发票请求参数")

@JsonInclude(NON_NULL)
public class DeletePreInvoicesRequest extends  PreInvoiceRequest {

    @JsonProperty("preInvoiceIds")
    private List<Long> preInvoiceIds;

    @ApiModelProperty("billIds")
    private List<Long> billIds;


    public List<Long> getBillIds() {
        return billIds;
    }

    public void setBillIds(List<Long> billIds) {
        this.billIds = billIds;
    }

    public List<Long> getPreInvoiceIds() {
        return preInvoiceIds;
    }

    public void setPreInvoiceIds(List<Long> preInvoiceIds) {
        this.preInvoiceIds = preInvoiceIds;
    }
}


