package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 发票详情--包含发票详情信息、发票明细列表信息、发票操作日志列表信息
 */
@ApiModel(description = "发票详情--包含发票详情信息、发票明细列表信息、发票操作日志列表信息")

@JsonInclude(NON_NULL)
@Data
public class InvoiceDetails {
  @JsonProperty("invoiceInfo")
  private SellerInvoiceInfo invoiceInfo = null;

  @JsonProperty("sellerInvoiceVehicleInfo")
  private SellerInvoiceVehicleInfo sellerInvoiceVehicleInfo = null;

  @JsonProperty("operationLogList")
  private List<InvoiceOperationLog> operationLogList = new ArrayList<InvoiceOperationLog>();

  @JsonProperty("invoiceItemList")
  private List<InvoiceItem> invoiceItemList = new ArrayList<InvoiceItem>();

  @JsonProperty("redOrBlueIds")
  private List<Long> redOrBlueIds = new ArrayList<Long>();



}
