package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.xforceplus.xplatframework.apimodel.PollingModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 数据
 */
@ApiModel(description = "数据")

@JsonInclude(NON_NULL)
public class InvoiceResponseData extends PollingModel {

    @ApiModelProperty(value = "下一张发票代码信息")
    private NextInvoiceInfo nextInvoiceInfo;

    public NextInvoiceInfo getNextInvoiceInfo() {
        return nextInvoiceInfo;
    }

    public void setNextInvoiceInfo(NextInvoiceInfo nextInvoiceInfo) {
        this.nextInvoiceInfo = nextInvoiceInfo;
    }

    @Override
    public String toString() {
        return "InvoiceResponseData{" +
                "nextInvoiceInfo=" + nextInvoiceInfo +
                "} " + super.toString();
    }
}
