package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

@ApiModel("发票金额统计")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class InvoiceSummaryReply {
    @ApiModelProperty("累计税额")
    private BigDecimal totalTaxAmount = BigDecimal.ZERO;
    @ApiModelProperty("累计含税金额")
    private BigDecimal totalAmountWithTax = BigDecimal.ZERO;
    @ApiModelProperty("累计不含税金额")
    private BigDecimal totalAmountWithoutTax = BigDecimal.ZERO;
}
