package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 发票信息分页返回结果
 */
@ApiModel(description = "发票信息分页返回结果")

@JsonInclude(NON_NULL)
@Data
public class InvoiceSummaryResult {
  @JsonProperty("normal")
  private Long normal = null;

  @JsonProperty("panding")
  private Long panding = null;

  @JsonProperty("abandoned")
  private Long abandoned = null;

  @JsonProperty("auditRejected")
  private Long auditRejected = null;

  @JsonProperty("auditPass")
  private Long auditPass = null;

  @JsonProperty("total")
  private Long total = null;

  private BigDecimal totalTaxAmount=BigDecimal.ZERO;

  private BigDecimal totalAmountWithTax=BigDecimal.ZERO;

  private BigDecimal totalAmountWithoutTax=BigDecimal.ZERO;


}
