package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel("开票记录数据")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class IssueRecordData {
    @ApiModelProperty("批次号")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long batchNo;
    @ApiModelProperty("发票类型")
    private String invoiceType;
    @ApiModelProperty("销方名称")
    private String sellerName;
    @ApiModelProperty("单据类型")
    private String salesbillType;
    @ApiModelProperty("是否自动开票")
    private Integer issueType;
    @ApiModelProperty("业务单号")
    private String salesbillNo;
    @ApiModelProperty("开票状态")
    private String status;
    @ApiModelProperty("创建时间")
    private String createTime;
    @ApiModelProperty("更新时间")
    private String updateTime;
    @ApiModelProperty("操作人")
    private String updateUserName;
    @ApiModelProperty("组织id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long sysOrgId;
    @ApiModelProperty("组织名称")
    private String sysOrgName;
    @ApiModelProperty("购方名称")
    private String purchaserName;
    @ApiModelProperty("批次号")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long serialNo;
    @ApiModelProperty("发票票种")
    private String invoiceKind;
    @ApiModelProperty("税控发票来源")
    private String taxInvoiceSource;
}
