package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@ApiModel("开票记录页面查询请求")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class IssueRecordQueryRequest {
    @ApiModelProperty("创建时间")
    private List<Long> createTime;
    @ApiModelProperty("开票申请状态")
    private String status;
    @ApiModelProperty("销方公司名称")
    private String sellerName;
    @ApiModelProperty("是否自动开具 0-否 1-是")
    private Integer issueType;
    @ApiModelProperty("业务单号")
    private String salesbillNo;
    @ApiModelProperty("单据类型集合")
    private List<String> salesbillType;
    @ApiModelProperty("发票类型集合")
    private List<String> invoiceType;
    @ApiModelProperty("组织id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long sysOrgId;
    @ApiModelProperty("购方名称")
    private String purchaserName;
    @ApiModelProperty("处理状态 1-待处理 2-已处理")
    private Integer handleStatus;
    @ApiModelProperty("发票票种")
    private List<String> invoiceKind;
    @ApiModelProperty("税控发票来源")
    private String taxInvoiceSource;
    @ApiModelProperty("分页信息")
    private Page page;
}
