package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.xforceplus.xplatframework.apimodel.PollingModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 数据
 */
@ApiModel(description = "数据")

@JsonInclude(NON_NULL)
public class MakeOutStatusData extends PollingModel {

    public static final int NOT_DONE = 0;

    public static final int DONE = 1;

    private Boolean singleReturn = false;

    private Integer total;

    private Integer successedNum;

    private Integer failedNum;

    private String deviceName;

    private String deviceNo;

    private String deviceTypeName;

    private String taxDeviceMachineNo;

    //5 Ukey
    private Integer terminalType ;
    //0 开具 1开具打印
    private Integer operationType ;

    private String invoiceType;

    private String issuer;

    private BigDecimal creditLimit;

    public String getDeviceName() {
        return deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getDeviceNo() {
        return deviceNo;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    public String getDeviceTypeName() {
        return deviceTypeName;
    }

    public void setDeviceTypeName(String deviceTypeName) {
        this.deviceTypeName = deviceTypeName;
    }

    public String getTaxDeviceMachineNo() {
        return taxDeviceMachineNo;
    }

    public void setTaxDeviceMachineNo(String taxDeviceMachineNo) {
        this.taxDeviceMachineNo = taxDeviceMachineNo;
    }

    public Boolean getSingleReturn() {
        return singleReturn;
    }

    public void setSingleReturn(Boolean singleReturn) {
        this.singleReturn = singleReturn;
    }

    public Integer getTotal() {
        return total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Integer getSuccessedNum() {
        return successedNum;
    }

    public void setSuccessedNum(Integer successedNum) {
        this.successedNum = successedNum;
    }

    public Integer getFailedNum() {
        return failedNum;
    }

    public void setFailedNum(Integer failedNum) {
        this.failedNum = failedNum;
    }

    public Integer getTerminalType() {
        return terminalType;
    }

    public void setTerminalType(Integer terminalType) {
        this.terminalType = terminalType;
    }

    public Integer getOperationType() {
        return operationType;
    }

    public void setOperationType(Integer operationType) {
        this.operationType = operationType;
    }

    @ApiModelProperty(value = "开具信息")
    private MakeOutStatusInfo makeOutStatusInfo = null;


    public MakeOutStatusInfo getMakeOutStatusInfo() {
        return makeOutStatusInfo;
    }

    public void setMakeOutStatusInfo(MakeOutStatusInfo makeOutStatusInfo) {
        this.makeOutStatusInfo = makeOutStatusInfo;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getIssuer() {
        return issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public BigDecimal getCreditLimit() {
        return creditLimit;
    }

    public void setCreditLimit(BigDecimal creditLimit) {
        this.creditLimit = creditLimit;
    }

    @Override
    public String toString() {
        return "MakeOutStatusData{" +
                "makeOutStatusInfo=" + makeOutStatusInfo +
                "} " + super.toString();
    }
}
