package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@ApiModel(description = "修改发票匹配的业务单号")
@JsonInclude(NON_NULL)
public class ModifyInvoiceBySalesRequest {

    @JsonProperty("salesbillId")
    private String salesbillId;//业务单id
    @JsonProperty("salesbillNo")
    private String salesbillNo;//业务单编号
    @JsonProperty("matchStatus")
    private String matchStatus;//1-已匹配，非1-取消匹配
    @JsonProperty("invoiceIds")
    private List<Long> invoiceIds;//发票集合
    @JsonProperty("systemOrig")
    private String systemOrig;//业务单来源

    private List<ModifyInvoiceBySalesRequest> bizorderInfos;// 业务单 Id 集合 ，多个业务单，对一个发票场景

    @ApiModelProperty(value = "业务单id")
    public String getSalesbillId() {
        return salesbillId;
    }

    public void setSalesbillId(String salesbillId) {
        this.salesbillId = salesbillId;
    }

    @ApiModelProperty(value = "业务单编号")
    public String getSalesbillNo() {
        return salesbillNo;
    }

    public void setSalesbillNo(String salesbillNo) {
        this.salesbillNo = salesbillNo;
    }

    @ApiModelProperty(value = "匹配状态")
    public String getMatchStatus() {
        return matchStatus;
    }

    public void setMatchStatus(String matchStatus) {
        this.matchStatus = matchStatus;
    }

    @ApiModelProperty(value = "发票id集合")
    public List<Long> getInvoiceIds() {
        return invoiceIds;
    }

    public void setInvoiceIds(List<Long> invoiceIds) {
        this.invoiceIds = invoiceIds;
    }

    @ApiModelProperty(value = "业务单来源")
    public String getSystemOrig() {
        return systemOrig;
    }

    public void setSystemOrig(String systemOrig) {
        this.systemOrig = systemOrig;
    }

    public List<ModifyInvoiceBySalesRequest> getBizorderInfos() {
        return bizorderInfos;
    }

    public void setBizorderInfos(List<ModifyInvoiceBySalesRequest> bizorderInfos) {
        this.bizorderInfos = bizorderInfos;
    }
}
