package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * MsDeleteBillRedNoAllRequestExcludes
 */

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsDeleteBillRedNoAllRequestExcludes {
  @JsonProperty("excludes")
  private List<Long> excludes = new ArrayList<Long>();

  @JsonProperty("includes")
  private List<Long> includes = new ArrayList<Long>();

  @JsonProperty("isAllSelected")
  private String isAllSelected = null;

  @JsonProperty("billId")
  private Long billId = null;

  @JsonIgnore
  public MsDeleteBillRedNoAllRequestExcludes excludes(List<Long> excludes) {
    this.excludes = excludes;
    return this;
  }

  public MsDeleteBillRedNoAllRequestExcludes addExcludesItem(Long excludesItem) {
    this.excludes.add(excludesItem);
    return this;
  }

   /**
   * Get excludes
   * @return excludes
  **/
  @ApiModelProperty(value = "")
  public List<Long> getExcludes() {
    return excludes;
  }

  public void setExcludes(List<Long> excludes) {
    this.excludes = excludes;
  }

  @JsonIgnore
  public MsDeleteBillRedNoAllRequestExcludes includes(List<Long> includes) {
    this.includes = includes;
    return this;
  }

  public MsDeleteBillRedNoAllRequestExcludes addIncludesItem(Long includesItem) {
    this.includes.add(includesItem);
    return this;
  }

   /**
   * Get includes
   * @return includes
  **/
  @ApiModelProperty(value = "")
  public List<Long> getIncludes() {
    return includes;
  }

  public void setIncludes(List<Long> includes) {
    this.includes = includes;
  }

  @JsonIgnore
  public MsDeleteBillRedNoAllRequestExcludes isAllSelected(String isAllSelected) {
    this.isAllSelected = isAllSelected;
    return this;
  }

   /**
   * 是否全选
   * @return isAllSelected
  **/
  @ApiModelProperty(value = "是否全选")
  public String getIsAllSelected() {
    return isAllSelected;
  }

  public void setIsAllSelected(String isAllSelected) {
    this.isAllSelected = isAllSelected;
  }

  @JsonIgnore
  public MsDeleteBillRedNoAllRequestExcludes billId(Long billId) {
    this.billId = billId;
    return this;
  }

   /**
   * 业务单Id
   * @return billId
  **/
  @ApiModelProperty(value = "业务单Id")
  public Long getBillId() {
    return billId;
  }

  public void setBillId(Long billId) {
    this.billId = billId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsDeleteBillRedNoAllRequestExcludes deleteBillRedNoAllRequestExcludes = (MsDeleteBillRedNoAllRequestExcludes) o;
    return Objects.equals(this.excludes, deleteBillRedNoAllRequestExcludes.excludes) &&
        Objects.equals(this.includes, deleteBillRedNoAllRequestExcludes.includes) &&
        Objects.equals(this.isAllSelected, deleteBillRedNoAllRequestExcludes.isAllSelected) &&
        Objects.equals(this.billId, deleteBillRedNoAllRequestExcludes.billId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(excludes, includes, isAllSelected, billId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsDeleteBillRedNoAllRequestExcludes {\n");

    sb.append("    excludes: ").append(toIndentedString(excludes)).append("\n");
    sb.append("    includes: ").append(toIndentedString(includes)).append("\n");
    sb.append("    isAllSelected: ").append(toIndentedString(isAllSelected)).append("\n");
    sb.append("    billId: ").append(toIndentedString(billId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
