package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 数量
 */
@ApiModel(description = "数量")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetRedNoUploadResultResponseResult {
  @JsonProperty("fail")
  private Integer fail = null;

  @JsonProperty("isDone")
  private Integer isDone = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("processing")
  private Integer processing = null;

  @JsonProperty("success")
  private Integer success = null;

  @JsonProperty("total")
  private Integer total = null;

  @JsonIgnore
  public MsGetRedNoUploadResultResponseResult fail(Integer fail) {
    this.fail = fail;
    return this;
  }

   /**
   * return code
   * @return fail
  **/
  @ApiModelProperty(value = "return code")
  public Integer getFail() {
    return fail;
  }

  public void setFail(Integer fail) {
    this.fail = fail;
  }

  @JsonIgnore
  public MsGetRedNoUploadResultResponseResult isDone(Integer isDone) {
    this.isDone = isDone;
    return this;
  }

   /**
   * return code
   * @return isDone
  **/
  @ApiModelProperty(value = "return code")
  public Integer getIsDone() {
    return isDone;
  }

  public void setIsDone(Integer isDone) {
    this.isDone = isDone;
  }

  @JsonIgnore
  public MsGetRedNoUploadResultResponseResult message(String message) {
    this.message = message;
    return this;
  }

   /**
   * return message
   * @return message
  **/
  @ApiModelProperty(value = "return message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsGetRedNoUploadResultResponseResult processing(Integer processing) {
    this.processing = processing;
    return this;
  }

   /**
   * return code
   * @return processing
  **/
  @ApiModelProperty(value = "return code")
  public Integer getProcessing() {
    return processing;
  }

  public void setProcessing(Integer processing) {
    this.processing = processing;
  }

  @JsonIgnore
  public MsGetRedNoUploadResultResponseResult success(Integer success) {
    this.success = success;
    return this;
  }

   /**
   * return code
   * @return success
  **/
  @ApiModelProperty(value = "return code")
  public Integer getSuccess() {
    return success;
  }

  public void setSuccess(Integer success) {
    this.success = success;
  }

  @JsonIgnore
  public MsGetRedNoUploadResultResponseResult total(Integer total) {
    this.total = total;
    return this;
  }

   /**
   * return code
   * @return total
  **/
  @ApiModelProperty(value = "return code")
  public Integer getTotal() {
    return total;
  }

  public void setTotal(Integer total) {
    this.total = total;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetRedNoUploadResultResponseResult getRedNoUploadResultResponseResult = (MsGetRedNoUploadResultResponseResult) o;
    return Objects.equals(this.fail, getRedNoUploadResultResponseResult.fail) &&
        Objects.equals(this.isDone, getRedNoUploadResultResponseResult.isDone) &&
        Objects.equals(this.message, getRedNoUploadResultResponseResult.message) &&
        Objects.equals(this.processing, getRedNoUploadResultResponseResult.processing) &&
        Objects.equals(this.success, getRedNoUploadResultResponseResult.success) &&
        Objects.equals(this.total, getRedNoUploadResultResponseResult.total);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fail, isDone, message, processing, success, total);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetRedNoUploadResultResponseResult {\n");

    sb.append("    fail: ").append(toIndentedString(fail)).append("\n");
    sb.append("    isDone: ").append(toIndentedString(isDone)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    processing: ").append(toIndentedString(processing)).append("\n");
    sb.append("    success: ").append(toIndentedString(success)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
