package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.xforceplus.xplatframework.apimodel.PollingModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * MsPollingSplitAndMakeOutResult
 */
@ApiModel(description = "拆票开票轮询结果")
@JsonInclude(NON_NULL)
@Data
@EqualsAndHashCode(callSuper = true)
public class MsPollingSplitAndMakeOutResult extends PollingModel {

    @ApiModelProperty(value = "拆票结果 0- 拆票中 1-成功 2- 部分成功")
    private int result;

    @ApiModelProperty(value = "批次号")
    private Long batchNo = null;

    @ApiModelProperty(value = "批次号集合")
    private List<String> batchNos;

    @ApiModelProperty(value = "拆票失败的")
    private List<Long> failBatchNoList;

    @ApiModelProperty(value = "发票类型")
    private String preInvoiceType = null;

    @ApiModelProperty(value = "预制发票集合")
    private List<PreInvoiceInfoPolling> preInvoiceList;

    @ApiModelProperty(value = "预制发票预览结束时间")
//    @Getter
//    @Setter
    private Long previewEndTime;

    @ApiModelProperty(value = "数电税号集合")
    private List<String> allElectricTaxNoList;

//    public int getResult() {
//        return result;
//    }
//
//    public void setResult(int result) {
//        this.result = result;
//    }
//
//    public List<Long> getFailBatchNoList() {
//        return failBatchNoList;
//    }
//
//    public void setFailBatchNoList(List<Long> failBatchNoList) {
//        this.failBatchNoList = failBatchNoList;
//    }
//
//    public String getPreInvoiceType() {
//        return preInvoiceType;
//    }
//
//    public void setPreInvoiceType(String preInvoiceType) {
//        this.preInvoiceType = preInvoiceType;
//    }
//
//    public Long getBatchNo() {
//        return batchNo;
//    }
//
//    public void setBatchNo(Long batchNo) {
//        this.batchNo = batchNo;
//    }
//
//    public List<PreInvoiceInfoPolling> getPreInvoiceList() {
//        return preInvoiceList;
//    }
//
//    public void setPreInvoiceList(List<PreInvoiceInfoPolling> preInvoiceList) {
//        this.preInvoiceList = preInvoiceList;
//    }
//
//    public List<String> getBatchNos() {
//        return batchNos;
//    }
//
//    public void setBatchNos(List<String> batchNos) {
//        this.batchNos = batchNos;
//    }
//
//    @Override
//    public String toString() {
//        return "MsPollingSplitAndMakeOutResult{" +
//                "batchNo=" + batchNo +
//                ", batchNos=" + batchNos +
//                ", preInvoiceType='" + preInvoiceType + '\'' +
//                ", preInvoiceList=" + preInvoiceList +
//                "} " + super.toString();
//    }
}
