package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsRedNoExportRequest {
  @JsonProperty("redNotifications")
  private List<Long> redNotifications = new ArrayList<Long>();

  @JsonIgnore
  public MsRedNoExportRequest redNotifications(List<Long> redNotifications) {
    this.redNotifications = redNotifications;
    return this;
  }

  public MsRedNoExportRequest addRedNotificationsItem(Long redNotificationsItem) {
    this.redNotifications.add(redNotificationsItem);
    return this;
  }

   /**
   * id
   * @return redNotifications
  **/
  @ApiModelProperty(value = "id")
  public List<Long> getRedNotifications() {
    return redNotifications;
  }

  public void setRedNotifications(List<Long> redNotifications) {
    this.redNotifications = redNotifications;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsRedNoExportRequest redNoExportRequest = (MsRedNoExportRequest) o;
    return Objects.equals(this.redNotifications, redNoExportRequest.redNotifications);
  }

  @Override
  public int hashCode() {
    return Objects.hash(redNotifications);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsRedNoExportRequest {\n");

    sb.append("    redNotifications: ").append(toIndentedString(redNotifications)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
