package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysRedNoByBillDto {
  @JsonProperty("billId")
  private Long billId = null;

  @JsonProperty("billNo")
  private String billNo = null;

  @JsonProperty("detailsCount")
  private Integer detailsCount = null;

  @JsonProperty("applyId")
  private String applyId = null;

  @JsonProperty("amountWithTax")
  private BigDecimal amountWithTax = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  public String getPaperDrawDate() {
    return paperDrawDate;
  }

  public void setPaperDrawDate(String paperDrawDate) {
    this.paperDrawDate = paperDrawDate;
  }

  @JsonProperty("paperDrawDate")
  private String paperDrawDate = null;
  @JsonProperty("applyRemark")
  private String applyRemark = null;

  @JsonProperty("sellerNo")
  private String sellerNo = null;

  @JsonProperty("purchaserNo")
  private String purchaserNo = null;

  /**
   * 0,未同步，1在同步中，2同步失败，3同步成功
   * 表 : inv_seller_red_notification
   * 对应字段 : sync_status
   */
  private Integer syncStatus;

  /**
   * TZD0000 - 审核通过,TZD0074 - 已核销,TZD0072 - 已核销，待查证,TZD0082 - 已撤销
   * 表 : inv_seller_red_notification
   * 对应字段 : red_status
   */
  private String redStatus;

  /**
   * 开票机号
   * 表 : inv_seller_red_notification
   * 对应字段 : machine_code
   */
  private String machineCode;

  /**
   * 同步异常原因
   * 表 : inv_seller_red_notification
   * 对应字段 : sync_message
   */
  private String syncMessage;

  /**
   * 同步code 0 没有异常,1.同步数据成功更新失败,2 发送到税件 失败，3 其他异常
   * 表 : inv_seller_red_notification
   * 对应字段 : sync_code
   */
  private Integer syncCode;

  /**
   * 同步序号
   * 表 : inv_seller_red_notification
   * 对应字段 : sync_serial_no
   */
  private String syncSerialNo;

  /**
   * 同步状态文字
   * 表 : inv_seller_red_notification
   * 对应字段 : sync_status_msg
   */
  private String syncStatusMsg;

  public String getApplyRemark() {
    return applyRemark;
  }

  public void setApplyRemark(String applyRemark) {
    this.applyRemark = applyRemark;
  }

  public Integer getApplyStatus() {
    return applyStatus;
  }

  public void setApplyStatus(Integer applyStatus) {
    this.applyStatus = applyStatus;
  }

  public Integer getApplyingStatus() {
    return applyingStatus;
  }

  public void setApplyingStatus(Integer applyingStatus) {
    this.applyingStatus = applyingStatus;
  }

  @JsonProperty("applyStatus")
  private Integer applyStatus = null;

  @JsonProperty("applyingStatus")
  private Integer applyingStatus = null;

  @JsonIgnore
  public MsSysRedNoByBillDto billId(Long billId) {
    this.billId = billId;
    return this;
  }

   /**
   * 主键ID
   * @return billId
  **/
  @ApiModelProperty(value = "主键ID")
  public Long getBillId() {
    return billId;
  }

  public void setBillId(Long billId) {
    this.billId = billId;
  }

  @JsonIgnore
  public MsSysRedNoByBillDto billNo(String billNo) {
    this.billNo = billNo;
    return this;
  }

   /**
   * 业务单号
   * @return billNo
  **/
  @ApiModelProperty(value = "业务单号")
  public String getBillNo() {
    return billNo;
  }

  public void setBillNo(String billNo) {
    this.billNo = billNo;
  }

  @JsonIgnore
  public MsSysRedNoByBillDto detailsCount(Integer detailsCount) {
    this.detailsCount = detailsCount;
    return this;
  }

   /**
   * 红字信息表长度
   * @return detailsCount
  **/
  @ApiModelProperty(value = "红字信息表长度")
  public Integer getDetailsCount() {
    return detailsCount;
  }

  public void setDetailsCount(Integer detailsCount) {
    this.detailsCount = detailsCount;
  }

  @JsonIgnore
  public MsSysRedNoByBillDto applyId(String applyId) {
    this.applyId = applyId;
    return this;
  }

   /**
   * 红字信息表Id
   * @return applyId
  **/
  @ApiModelProperty(value = "红字信息表Id")
  public String getApplyId() {
    return applyId;
  }

  public void setApplyId(String applyId) {
    this.applyId = applyId;
  }

  @JsonIgnore
  public MsSysRedNoByBillDto amountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 价税合计
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "价税合计")
  public BigDecimal getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public MsSysRedNoByBillDto amountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 合计金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "合计金额")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public MsSysRedNoByBillDto taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 合计税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "合计税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MsSysRedNoByBillDto sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public MsSysRedNoByBillDto purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public MsSysRedNoByBillDto createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  public String getSellerNo() {
    return sellerNo;
  }

  public void setSellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
  }

  public String getPurchaserNo() {
    return purchaserNo;
  }

  public void setPurchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
  }



  @Override
  public int hashCode() {
    return Objects.hash(billId, billNo, detailsCount, applyId, amountWithTax, amountWithoutTax, taxAmount, sellerName, purchaserName, createTime);
  }


  @Override
  public String toString() {
    return "MsSysRedNoByBillDto{" +
            "billId=" + billId +
            ", billNo='" + billNo + '\'' +
            ", detailsCount=" + detailsCount +
            ", applyId='" + applyId + '\'' +
            ", amountWithTax=" + amountWithTax +
            ", amountWithoutTax=" + amountWithoutTax +
            ", taxAmount=" + taxAmount +
            ", sellerName='" + sellerName + '\'' +
            ", purchaserName='" + purchaserName + '\'' +
            ", createTime='" + createTime + '\'' +
            ", applyRemark='" + applyRemark + '\'' +
            ", sellerNo='" + sellerNo + '\'' +
            ", purchaserNo='" + purchaserNo + '\'' +
            ", applyStatus=" + applyStatus +
            ", applyingStatus=" + applyingStatus +
            '}';
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  public Integer getSyncStatus() {
    return syncStatus;
  }

  public void setSyncStatus(Integer syncStatus) {
    this.syncStatus = syncStatus;
  }

  public String getRedStatus() {
    return redStatus;
  }

  public void setRedStatus(String redStatus) {
    this.redStatus = redStatus;
  }

  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  public String getSyncMessage() {
    return syncMessage;
  }

  public void setSyncMessage(String syncMessage) {
    this.syncMessage = syncMessage;
  }

  public Integer getSyncCode() {
    return syncCode;
  }

  public void setSyncCode(Integer syncCode) {
    this.syncCode = syncCode;
  }

  public String getSyncSerialNo() {
    return syncSerialNo;
  }

  public void setSyncSerialNo(String syncSerialNo) {
    this.syncSerialNo = syncSerialNo;
  }

  public String getSyncStatusMsg() {
    return syncStatusMsg;
  }

  public void setSyncStatusMsg(String syncStatusMsg) {
    this.syncStatusMsg = syncStatusMsg;
  }
}
