package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysRedNoDetailDto {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("applyId")
  private Long applyId = null;

  @JsonProperty("cargoName")
  private String cargoName = null;

  @JsonProperty("itemSpec")
  private String itemSpec = null;

  @JsonProperty("quantityUnit")
  private String quantityUnit = null;

  @JsonProperty("amountWithTax")
  private String amountWithTax = null;

  @JsonProperty("amountWithoutTax")
  private String amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private String taxAmount = null;

  @JsonProperty("quantity")
  private String quantity = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("unitPrice")
  private String unitPrice = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("sellerNumber")
  private String sellerNumber = null;

  @JsonIgnore
  public MsSysRedNoDetailDto id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 主键ID
   * @return id
  **/
  @ApiModelProperty(value = "主键ID")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsSysRedNoDetailDto applyId(Long applyId) {
    this.applyId = applyId;
    return this;
  }

   /**
   * 红字信息表Id
   * @return applyId
  **/
  @ApiModelProperty(value = "红字信息表Id")
  public Long getApplyId() {
    return applyId;
  }

  public void setApplyId(Long applyId) {
    this.applyId = applyId;
  }

  @JsonIgnore
  public MsSysRedNoDetailDto cargoName(String cargoName) {
    this.cargoName = cargoName;
    return this;
  }

   /**
   * 货物或服务名称
   * @return cargoName
  **/
  @ApiModelProperty(value = "货物或服务名称")
  public String getCargoName() {
    return cargoName;
  }

  public void setCargoName(String cargoName) {
    this.cargoName = cargoName;
  }

  @JsonIgnore
  public MsSysRedNoDetailDto itemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
    return this;
  }

   /**
   * 规格型号
   * @return itemSpec
  **/
  @ApiModelProperty(value = "规格型号")
  public String getItemSpec() {
    return itemSpec;
  }

  public void setItemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
  }

  @JsonIgnore
  public MsSysRedNoDetailDto quantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
    return this;
  }

   /**
   * 数量单位
   * @return quantityUnit
  **/
  @ApiModelProperty(value = "数量单位")
  public String getQuantityUnit() {
    return quantityUnit;
  }

  public void setQuantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
  }

  @JsonIgnore
  public MsSysRedNoDetailDto amountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public String getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public MsSysRedNoDetailDto amountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public String getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public MsSysRedNoDetailDto taxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public String getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MsSysRedNoDetailDto quantity(String quantity) {
    this.quantity = quantity;
    return this;
  }

   /**
   * 数量
   * @return quantity
  **/
  @ApiModelProperty(value = "数量")
  public String getQuantity() {
    return quantity;
  }

  public void setQuantity(String quantity) {
    this.quantity = quantity;
  }

  @JsonIgnore
  public MsSysRedNoDetailDto taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public MsSysRedNoDetailDto unitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * 不含税单价
   * @return unitPrice
  **/
  @ApiModelProperty(value = "不含税单价")
  public String getUnitPrice() {
    return unitPrice;
  }

  public void setUnitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
  }

  @JsonIgnore
  public MsSysRedNoDetailDto createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsSysRedNoDetailDto sellerNumber(String sellerNumber) {
    this.sellerNumber = sellerNumber;
    return this;
  }

   /**
   * 流水号
   * @return sellerNumber
  **/
  @ApiModelProperty(value = "流水号")
  public String getSellerNumber() {
    return sellerNumber;
  }

  public void setSellerNumber(String sellerNumber) {
    this.sellerNumber = sellerNumber;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysRedNoDetailDto sysRedNoDetailDto = (MsSysRedNoDetailDto) o;
    return Objects.equals(this.id, sysRedNoDetailDto.id) &&
        Objects.equals(this.applyId, sysRedNoDetailDto.applyId) &&
        Objects.equals(this.cargoName, sysRedNoDetailDto.cargoName) &&
        Objects.equals(this.itemSpec, sysRedNoDetailDto.itemSpec) &&
        Objects.equals(this.quantityUnit, sysRedNoDetailDto.quantityUnit) &&
        Objects.equals(this.amountWithTax, sysRedNoDetailDto.amountWithTax) &&
        Objects.equals(this.amountWithoutTax, sysRedNoDetailDto.amountWithoutTax) &&
        Objects.equals(this.taxAmount, sysRedNoDetailDto.taxAmount) &&
        Objects.equals(this.quantity, sysRedNoDetailDto.quantity) &&
        Objects.equals(this.taxRate, sysRedNoDetailDto.taxRate) &&
        Objects.equals(this.unitPrice, sysRedNoDetailDto.unitPrice) &&
        Objects.equals(this.createTime, sysRedNoDetailDto.createTime) &&
        Objects.equals(this.sellerNumber, sysRedNoDetailDto.sellerNumber);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, applyId, cargoName, itemSpec, quantityUnit, amountWithTax, amountWithoutTax, taxAmount, quantity, taxRate, unitPrice, createTime, sellerNumber);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysRedNoDetailDto {\n");

    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    applyId: ").append(toIndentedString(applyId)).append("\n");
    sb.append("    cargoName: ").append(toIndentedString(cargoName)).append("\n");
    sb.append("    itemSpec: ").append(toIndentedString(itemSpec)).append("\n");
    sb.append("    quantityUnit: ").append(toIndentedString(quantityUnit)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    sellerNumber: ").append(toIndentedString(sellerNumber)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
