package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * MsSysRedNoImportDtoInnerRedNotificationMain
 */

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysRedNoImportDtoInnerRedNotificationMain {
  @JsonProperty("sellNumber")
  private String sellNumber = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("sellerNo")
  private String sellerNo = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("purchaserNo")
  private String purchaserNo = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("amountWithTax")
  private BigDecimal amountWithTax = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("proposerName")
  private String proposerName = null;

  @JsonProperty("proposerTel")
  private String proposerTel = null;

  @JsonProperty("reason")
  private String reason = null;

  @JsonProperty("petroleumReason")
  private String petroleumReason = null;

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationMain sellNumber(String sellNumber) {
    this.sellNumber = sellNumber;
    return this;
  }

   /**
   * 申请流水号
   * @return sellNumber
  **/
  @ApiModelProperty(value = "申请流水号")
  public String getSellNumber() {
    return sellNumber;
  }

  public void setSellNumber(String sellNumber) {
    this.sellNumber = sellNumber;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationMain invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型(c-普纸,s-专纸,ce-电票,v-机动车票,fj-附件,cj:卷票,a-其他发票)
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型(c-普纸,s-专纸,ce-电票,v-机动车票,fj-附件,cj:卷票,a-其他发票)")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationMain sellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
    return this;
  }

   /**
   * 销方编号
   * @return sellerNo
  **/
  @ApiModelProperty(value = "销方编号")
  public String getSellerNo() {
    return sellerNo;
  }

  public void setSellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationMain sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationMain sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationMain purchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
    return this;
  }

   /**
   * 购方编号
   * @return purchaserNo
  **/
  @ApiModelProperty(value = "购方编号")
  public String getPurchaserNo() {
    return purchaserNo;
  }

  public void setPurchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationMain purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationMain purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationMain invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationMain invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationMain amountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public BigDecimal getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationMain amountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationMain taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationMain proposerName(String proposerName) {
    this.proposerName = proposerName;
    return this;
  }

   /**
   * 申请人名称
   * @return proposerName
  **/
  @ApiModelProperty(value = "申请人名称")
  public String getProposerName() {
    return proposerName;
  }

  public void setProposerName(String proposerName) {
    this.proposerName = proposerName;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationMain proposerTel(String proposerTel) {
    this.proposerTel = proposerTel;
    return this;
  }

   /**
   * 申请方联系方式
   * @return proposerTel
  **/
  @ApiModelProperty(value = "申请方联系方式")
  public String getProposerTel() {
    return proposerTel;
  }

  public void setProposerTel(String proposerTel) {
    this.proposerTel = proposerTel;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationMain reason(String reason) {
    this.reason = reason;
    return this;
  }

   /**
   * 申请原因
   * @return reason
  **/
  @ApiModelProperty(value = "申请原因")
  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationMain petroleumReason(String petroleumReason) {
    this.petroleumReason = petroleumReason;
    return this;
  }

   /**
   * 成品油申请原因
   * @return petroleumReason
  **/
  @ApiModelProperty(value = "成品油申请原因")
  public String getPetroleumReason() {
    return petroleumReason;
  }

  public void setPetroleumReason(String petroleumReason) {
    this.petroleumReason = petroleumReason;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysRedNoImportDtoInnerRedNotificationMain sysRedNoImportDtoInnerRedNotificationMain = (MsSysRedNoImportDtoInnerRedNotificationMain) o;
    return Objects.equals(this.sellNumber, sysRedNoImportDtoInnerRedNotificationMain.sellNumber) &&
        Objects.equals(this.invoiceType, sysRedNoImportDtoInnerRedNotificationMain.invoiceType) &&
        Objects.equals(this.sellerNo, sysRedNoImportDtoInnerRedNotificationMain.sellerNo) &&
        Objects.equals(this.sellerTaxNo, sysRedNoImportDtoInnerRedNotificationMain.sellerTaxNo) &&
        Objects.equals(this.sellerName, sysRedNoImportDtoInnerRedNotificationMain.sellerName) &&
        Objects.equals(this.purchaserNo, sysRedNoImportDtoInnerRedNotificationMain.purchaserNo) &&
        Objects.equals(this.purchaserTaxNo, sysRedNoImportDtoInnerRedNotificationMain.purchaserTaxNo) &&
        Objects.equals(this.purchaserName, sysRedNoImportDtoInnerRedNotificationMain.purchaserName) &&
        Objects.equals(this.invoiceCode, sysRedNoImportDtoInnerRedNotificationMain.invoiceCode) &&
        Objects.equals(this.invoiceNo, sysRedNoImportDtoInnerRedNotificationMain.invoiceNo) &&
        Objects.equals(this.amountWithTax, sysRedNoImportDtoInnerRedNotificationMain.amountWithTax) &&
        Objects.equals(this.amountWithoutTax, sysRedNoImportDtoInnerRedNotificationMain.amountWithoutTax) &&
        Objects.equals(this.taxAmount, sysRedNoImportDtoInnerRedNotificationMain.taxAmount) &&
        Objects.equals(this.proposerName, sysRedNoImportDtoInnerRedNotificationMain.proposerName) &&
        Objects.equals(this.proposerTel, sysRedNoImportDtoInnerRedNotificationMain.proposerTel) &&
        Objects.equals(this.reason, sysRedNoImportDtoInnerRedNotificationMain.reason) &&
        Objects.equals(this.petroleumReason, sysRedNoImportDtoInnerRedNotificationMain.petroleumReason);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sellNumber, invoiceType, sellerNo, sellerTaxNo, sellerName, purchaserNo, purchaserTaxNo, purchaserName, invoiceCode, invoiceNo, amountWithTax, amountWithoutTax, taxAmount, proposerName, proposerTel, reason, petroleumReason);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysRedNoImportDtoInnerRedNotificationMain {\n");

    sb.append("    sellNumber: ").append(toIndentedString(sellNumber)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    sellerNo: ").append(toIndentedString(sellerNo)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    purchaserNo: ").append(toIndentedString(purchaserNo)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    proposerName: ").append(toIndentedString(proposerName)).append("\n");
    sb.append("    proposerTel: ").append(toIndentedString(proposerTel)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    petroleumReason: ").append(toIndentedString(petroleumReason)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
