package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysRedNoTerminalDto {
  @JsonProperty("id")
  private Integer id = null;

  @JsonProperty("terminalName")
  private String terminalName = null;

  @JsonProperty("terminalCode")
  private String terminalCode = null;

  @JsonIgnore
  public MsSysRedNoTerminalDto id(Integer id) {
    this.id = id;
    return this;
  }

   /**
   * 主键ID
   * @return id
  **/
  @ApiModelProperty(value = "主键ID")
  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  @JsonIgnore
  public MsSysRedNoTerminalDto terminalName(String terminalName) {
    this.terminalName = terminalName;
    return this;
  }

   /**
   * 终端名称
   * @return terminalName
  **/
  @ApiModelProperty(value = "终端名称")
  public String getTerminalName() {
    return terminalName;
  }

  public void setTerminalName(String terminalName) {
    this.terminalName = terminalName;
  }

  @JsonIgnore
  public MsSysRedNoTerminalDto terminalCode(String terminalCode) {
    this.terminalCode = terminalCode;
    return this;
  }

   /**
   * 终端代码
   * @return terminalCode
  **/
  @ApiModelProperty(value = "终端代码")
  public String getTerminalCode() {
    return terminalCode;
  }

  public void setTerminalCode(String terminalCode) {
    this.terminalCode = terminalCode;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysRedNoTerminalDto sysRedNoTerminalDto = (MsSysRedNoTerminalDto) o;
    return Objects.equals(this.id, sysRedNoTerminalDto.id) &&
        Objects.equals(this.terminalName, sysRedNoTerminalDto.terminalName) &&
        Objects.equals(this.terminalCode, sysRedNoTerminalDto.terminalCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, terminalName, terminalCode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysRedNoTerminalDto {\n");

    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    terminalName: ").append(toIndentedString(terminalName)).append("\n");
    sb.append("    terminalCode: ").append(toIndentedString(terminalCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
