package com.xforceplus.seller.invoice.client.model;

import com.xforceplus.xplatframework.apimodel.BaseResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;

@ApiModel
public class NotMakeOutInvoiceResponse extends BaseResponse {


    @ApiModelProperty
    private NotMakeOutInvoiceResult result;

    public NotMakeOutInvoiceResult getResult() {
        return result;
    }

    public void setResult(NotMakeOutInvoiceResult result) {
        this.result = result;
    }


    public static NotMakeOutInvoiceResponse createEmptyResponse() {
        NotMakeOutInvoiceResponse response = new NotMakeOutInvoiceResponse();
        response.setCode(BaseResponse.OK);
        NotMakeOutInvoiceResult result = new NotMakeOutInvoiceResult();
        result.setPreInvoices(new ArrayList<>());
        result.setTotal(0L);
        result.setTotalTaxAmount("0");
        result.setTotalWithoutAmount("0");
        response.setResult(result);
        return response;
    }

    @Override
    public String toString() {
        return "NotMakeOutInvoiceResponse{" +
                "result=" + result +
                "} " + super.toString();
    }
}
