package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 日志信息
 */
@ApiModel(description = "日志信息")

@JsonInclude(NON_NULL)
public class OpLog {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("operationDesc")
  private String operationDesc = null;

  @JsonProperty("operationContent")
  private String operationContent = null;

  @JsonProperty("operationTime")
  private String operationTime = null;

  @JsonProperty("operationUserName")
  private String operationUserName = null;

  @JsonIgnore
  public OpLog id(Long id) {
    this.id = id;
    return this;
  }

    /**
   * 主键
   * @return id
     **/
  @ApiModelProperty(value = "主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public OpLog operationDesc(String operationDesc) {
    this.operationDesc = operationDesc;
    return this;
  }

    /**
   * 业务操作描述
   * @return operationDesc
     **/
  @ApiModelProperty(value = "业务操作描述")
  public String getOperationDesc() {
    return operationDesc;
  }

  public void setOperationDesc(String operationDesc) {
    this.operationDesc = operationDesc;
  }

  @JsonIgnore
  public OpLog operationContent(String operationContent) {
    this.operationContent = operationContent;
    return this;
  }

    /**
   * 业务操作内容
   * @return operationContent
     **/
  @ApiModelProperty(value = "业务操作内容")
  public String getOperationContent() {
    return operationContent;
  }

  public void setOperationContent(String operationContent) {
    this.operationContent = operationContent;
  }

  @JsonIgnore
  public OpLog operationTime(String operationTime) {
    this.operationTime = operationTime;
    return this;
  }

    /**
   * 操作时间
   * @return operationTime
     **/
  @ApiModelProperty(value = "操作时间")
  public String getOperationTime() {
    return operationTime;
  }

  public void setOperationTime(String operationTime) {
    this.operationTime = operationTime;
  }

  @JsonIgnore
  public OpLog operationUserName(String operationUserName) {
    this.operationUserName = operationUserName;
    return this;
  }

    /**
   * 操作用户名
   * @return operationUserName
     **/
  @ApiModelProperty(value = "操作用户名")
  public String getOperationUserName() {
    return operationUserName;
  }

  public void setOperationUserName(String operationUserName) {
    this.operationUserName = operationUserName;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OpLog opLog = (OpLog) o;
    return Objects.equals(this.id, opLog.id) &&
            Objects.equals(this.operationDesc, opLog.operationDesc) &&
            Objects.equals(this.operationContent, opLog.operationContent) &&
            Objects.equals(this.operationTime, opLog.operationTime) &&
            Objects.equals(this.operationUserName, opLog.operationUserName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, operationDesc, operationContent, operationTime, operationUserName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OpLog {\n");

      sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    operationDesc: ").append(toIndentedString(operationDesc)).append("\n");
    sb.append("    operationContent: ").append(toIndentedString(operationContent)).append("\n");
    sb.append("    operationTime: ").append(toIndentedString(operationTime)).append("\n");
    sb.append("    operationUserName: ").append(toIndentedString(operationUserName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
