package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.*;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制发票信息
 */
@ApiModel(description = "预制发票信息")

@JsonInclude(NON_NULL)
@Data
public class PreInvoice {
    @JsonProperty("id")
    private Long id = null;

    @JsonProperty("batchNo")
    private Long batchNo = null;

    /**
     * 业务单号
     * 表 : inv_seller_pre_invoice
     * 对应字段 : salesbill_no
     */
    @JsonProperty("salesbillNo")
    private String salesbillNo;

    /**
     * 业务单id
     * 表 : inv_seller_pre_invoice
     * 对应字段 : salesbill_id
     */
    @JsonProperty("salesbillId")
    private Long salesbillId;

    @ApiModelProperty("外部批次号")
    private Long outBatchNo;

    @JsonProperty("sellerTenantId")
    private String sellerTenantId = null;

    @ApiModelProperty("销方集团Id")
    @JsonProperty("sellerGroupId")
    private String sellerGroupId = null;

    @ApiModelProperty("销方公司Id")
    @JsonProperty("sellerId")
    private String sellerId = null;

    @ApiModelProperty("预制发票状态")
    @JsonProperty("status")
    private Integer status;

    @JsonProperty("sellerNo")
    private String sellerNo = null;

    @JsonProperty("sellerCode")
    private String sellerCode = null;

    @JsonProperty("sellerName")
    private String sellerName = null;

    @JsonProperty("sellerTaxNo")
    private String sellerTaxNo = null;

    @JsonProperty("sellerTel")
    private String sellerTel = null;

    @JsonProperty("sellerAddress")
    private String sellerAddress = null;

    @JsonProperty("sellerBankName")
    private String sellerBankName = null;

    @JsonProperty("sellerBankAccount")
    private String sellerBankAccount = null;

    @JsonProperty("purchaserName")
    private String purchaserName = null;

    @JsonProperty("purchaserTenantId")
    private String purchaserTenantId = null;

    @ApiModelProperty("购方集团Id")
    @JsonProperty("purchaserGroupId")
    private String purchaserGroupId = null;

    @JsonProperty("purchaserId")
    private String purchaserId = null;

    @JsonProperty("purchaserNo")
    private String purchaserNo = null;

    @JsonProperty("purchaserTaxNo")
    private String purchaserTaxNo = null;

    @JsonProperty("purchaserTel")
    private String purchaserTel = null;

    @JsonProperty("purchaserAddress")
    private String purchaserAddress = null;

    @JsonProperty("purchaserBankName")
    private String purchaserBankName = null;

    @JsonProperty("purchaserBankAccount")
    private String purchaserBankAccount = null;

    @JsonProperty("invoiceType")
    private String invoiceType = null;

    @JsonProperty("businessBillType")
    private String businessBillType = null;

    @JsonProperty("salesbillType")
    private String salesbillType = null;

    @JsonProperty("invoiceCode")
    private String invoiceCode = null;

    @JsonProperty("invoiceNo")
    private String invoiceNo = null;

    @JsonProperty("machineCode")
    private String machineCode = null;

    @JsonProperty("paperDrawDate")
    private String paperDrawDate = null;

    @JsonProperty("checkCode")
    private String checkCode = null;

    @JsonProperty("cashierName")
    private String cashierName = null;

    @JsonProperty("checkerName")
    private String checkerName = null;

    @JsonProperty("invoicerName")
    private String invoicerName = null;

    @JsonProperty("remark")
    private String remark = null;

    @JsonProperty("electronicSignature")
    private String electronicSignature = null;

    @JsonProperty("amountWithTax")
    private BigDecimal amountWithTax = null;

    @JsonProperty("amountWithoutTax")
    private BigDecimal amountWithoutTax = null;

    @JsonProperty("taxAmount")
    private BigDecimal taxAmount = null;

    @JsonProperty("cipherText")
    private String cipherText = null;

    @JsonProperty("cipherTextTwoCode")
    private String cipherTextTwoCode = null;

    @ApiModelProperty("销货清单文件打印标志 (0-否, 1-是)")
    private int saleListFileFlag;

    @ApiModelProperty("打印内容标志 (0-打印单价和数量, 1-不打印单价和数量)")
    private int displayPriceQuality;

    @ApiModelProperty("显示税率")
    private String taxRateStr;

    @ApiModelProperty("显示税额")
    private String taxAmountStr;

    @ApiModelProperty("显示不含税金额")
    private String amountWithoutTaxStr;

    @ApiModelProperty("显示含税金额")
    private String amountWithTaxStr;

    @ApiModelProperty("特殊发票标记  0-默认  1-通行费   2-成品油")
    private String specialInvoiceFlag;

    @ApiModelProperty("红字信息编号")
    private String redNotificationNo;

    @ApiModelProperty("原发票号码")
    private String originInvoiceNo;

    @ApiModelProperty("原发票代码")
    private String originInvoiceCode;

    @ApiModelProperty("原发票类型")
    private String originInvoiceType;

    @ApiModelProperty("原开票日期")
    private String originPaperDrawDate;

    @ApiModelProperty("处理标记")
    private String processFlag;

    @ApiModelProperty("处理备注")
    private String processRemark;

    @ApiModelProperty("开具原因")
    private String makingReason;

    @ApiModelProperty("国税发票来源")
    private String taxInvoiceSource;

    @ApiModelProperty("发票票种")
    private String invoiceKind;

    @ApiModelProperty("扩展备注")
    private String extRemark;

    @ApiModelProperty("备注")
    private String originRemark;

    @ApiModelProperty("发票签名 用于抽取匹配")
    private String invoiceSignature;

    @ApiModelProperty("版式文件版本 (0-使用5行模版, 1-使用8行模版)(仅服务器开电票使用) ")
    private String templateVersion;

    @ApiModelProperty("销货清单备注")
    private String listGoodsName;

    @ApiModelProperty("红冲原因")
    private String redReason;

    @ApiModelProperty("发票状态")
    private Integer invoiceStatus;

    @JsonProperty("ext1")
    private String ext1 = null;

    @JsonProperty("ext2")
    private String ext2 = null;

    @JsonProperty("ext3")
    private String ext3 = null;

    @JsonProperty("ext4")
    private String ext4 = null;

    @JsonProperty("ext5")
    private String ext5 = null;

    @JsonProperty("ext6")
    private String ext6 = null;

    @JsonProperty("ext7")
    private String ext7 = null;

    @JsonProperty("ext8")
    private String ext8 = null;

    @JsonProperty("ext9")
    private String ext9 = null;

    @JsonProperty("ext10")
    private String ext10 = null;

    @JsonProperty("ext11")
    private String ext11 = null;

    @JsonProperty("ext12")
    private String ext12 = null;

    @JsonProperty("ext13")
    private String ext13 = null;

    @JsonProperty("ext14")
    private String ext14 = null;

    @JsonProperty("ext15")
    private String ext15 = null;

    @JsonProperty("ext16")
    private String ext16 = null;

    @JsonProperty("ext17")
    private String ext17 = null;

    @JsonProperty("ext18")
    private String ext18 = null;

    @JsonProperty("ext19")
    private String ext19 = null;

    @JsonProperty("ext20")
    private String ext20 = null;

    @JsonProperty("ext21")
    private String ext21 = null;

    @JsonProperty("ext22")
    private String ext22 = null;

    @JsonProperty("ext23")
    private String ext23 = null;

    @JsonProperty("ext24")
    private String ext24 = null;

    @JsonProperty("ext25")
    private String ext25 = null;

    /**
     * 系统来源类型: 0接口传入，1页面导入
     * 表 : inv_seller_pre_invoice
     * 对应字段 : system_orig_type
     */
    @JsonProperty("systemOrigType")
    private Integer systemOrigType;

    @JsonProperty("sysOrgId")
    private Long sysOrgId;

    @JsonProperty("createTime")
    private Date createTime;

    @JsonProperty("updateTime")
    private Date updateTime;

    /**
     * 系统来源  下发数据需要  由属地直接传过来
     * 表 : inv_seller_pre_invoice
     * 对应字段 : system_orig
*/    @JsonProperty("systemOrig")
    private String systemOrig;

    @JsonProperty("purchaserType")
    private Integer purchaserType;

    @ApiModelProperty("机动车信息")
    private SellerPreInvoiceVehicleInfo preInvoiceVehicleInfo;

    @JsonProperty("preInvoiceDetails")
    private List<PreInvoiceDetail> preInvoiceDetails = new ArrayList<PreInvoiceDetail>();

    @JsonProperty("specialAdditions")
    public List<Map<String, Object>> specialAdditions;

    @ApiModelProperty("红字信息表标识（属地用）")
    private Integer redNotificationFlag;

    private String customerNo;

    private String receiveUserEmail;

    private String receiveUserTel;

    @ApiModelProperty("关系集合")
    private List<PreSalesDetailRelationAddDto> preSalesDetailAddList;

}
