package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * PreInvoiceItemInfo
 */

@JsonInclude(NON_NULL)
public class PreInvoiceItemInfo {

    @NotNull
    @JsonProperty("amount")
    @Min(value = -10L, message = "容差金额不能小于负十")
    @Max(value = 10L, message = "容差金额不能大于十")
    private Double amount = null;

    @NotNull
    @JsonProperty("preInvoiceItemId")
    private Long preInvoiceItemId = null;

    @JsonIgnore
    public PreInvoiceItemInfo amount(Double amount) {
        this.amount = amount;
        return this;
    }

    /**
     * 金额
     *
     * @return amount
     **/
    @ApiModelProperty(value = "金额")
    public Double getAmount() {
        return amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    @JsonIgnore
    public PreInvoiceItemInfo preInvoiceItemId(Long preInvoiceItemId) {
        this.preInvoiceItemId = preInvoiceItemId;
        return this;
    }

    /**
     * 预制发票明细id
     *
     * @return preInvoiceItemId
     **/
    @ApiModelProperty(value = "预制发票明细id")
    public Long getPreInvoiceItemId() {
        return preInvoiceItemId;
    }

    public void setPreInvoiceItemId(Long preInvoiceItemId) {
        this.preInvoiceItemId = preInvoiceItemId;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PreInvoiceItemInfo preInvoiceItemInfo = (PreInvoiceItemInfo) o;
        return Objects.equals(this.amount, preInvoiceItemInfo.amount) &&
                Objects.equals(this.preInvoiceItemId, preInvoiceItemInfo.preInvoiceItemId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(amount, preInvoiceItemId);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PreInvoiceItemInfo {\n");

        sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
        sb.append("    preInvoiceItemId: ").append(toIndentedString(preInvoiceItemId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
