package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@JsonInclude(NON_NULL)
@ApiModel(description = "原明细与预制发票金额占比查询")
public class PreInvoiceOriginalSalesDetailQueryRequest {

    @JsonProperty("originalSalesbillItemIdList")
    @ApiModelProperty(value = "原业务单明细Id集合")
    private List<Long> originalSalesbillItemIdList = null;

    public List<Long> getOriginalSalesbillItemIdList() {
        return originalSalesbillItemIdList;
    }

    public void setOriginalSalesbillItemIdList(List<Long> originalSalesbillItemIdList) {
        this.originalSalesbillItemIdList = originalSalesbillItemIdList;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PreInvoiceOriginalSalesDetailQueryRequest that = (PreInvoiceOriginalSalesDetailQueryRequest) o;

        return getOriginalSalesbillItemIdList() != null ? getOriginalSalesbillItemIdList().equals(that.getOriginalSalesbillItemIdList()) : that.getOriginalSalesbillItemIdList() == null;
    }

    @Override
    public int hashCode() {
        return getOriginalSalesbillItemIdList() != null ? getOriginalSalesbillItemIdList().hashCode() : 0;
    }

    @Override
    public String toString() {
        return "PreInvoiceOriginalSalesDetailQueryRequest{" +
                "originalSalesbillItemIdList=" + originalSalesbillItemIdList +
                '}';
    }
}
