package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * PreInvoicePageInfo
 */

@JsonInclude(NON_NULL)
public class PreInvoicePageInfo {
  @JsonProperty("preInvoiceId")
  @NotNull
  private Long preInvoiceId;

  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonIgnore
  public PreInvoicePageInfo preInvoiceId(Long preInvoiceId) {
    this.preInvoiceId = preInvoiceId;
    return this;
  }

   /**
   * 预制发票id
     *
   * @return preInvoiceId
  **/
  @ApiModelProperty(value = "预制发票id")
  public Long getPreInvoiceId() {
    return preInvoiceId;
  }

  public void setPreInvoiceId(Long preInvoiceId) {
    this.preInvoiceId = preInvoiceId;
  }

  @JsonIgnore
  public PreInvoicePageInfo pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * 页码
     *
   * @return pageNo
  **/
  @ApiModelProperty(value = "页码")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public PreInvoicePageInfo pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 每页数据量
     *
   * @return pageSize
  **/
  @ApiModelProperty(value = "每页数据量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PreInvoicePageInfo preInvoicePageInfo = (PreInvoicePageInfo) o;
    return Objects.equals(this.preInvoiceId, preInvoicePageInfo.preInvoiceId) &&
        Objects.equals(this.pageNo, preInvoicePageInfo.pageNo) &&
        Objects.equals(this.pageSize, preInvoicePageInfo.pageSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(preInvoiceId, pageNo, pageSize);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PreInvoicePageInfo {\n");

    sb.append("    preInvoiceId: ").append(toIndentedString(preInvoiceId)).append("\n");
    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
