package com.xforceplus.seller.invoice.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.seller.invoice.client.model.open.ErrorData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * @author adnis
 */
@ApiModel(description = "返回结果")
@JsonInclude(NON_NULL)
@ToString
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PreInvoiceUpdateResult {

    @ApiModelProperty(value = "成功返回")
    private List<String> successResult;

    @ApiModelProperty(value = "失败返回")
    private Map<String, List<String>> failResult;
}
