package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * PrintSaleListRequest
 */

@JsonInclude(NON_NULL)
public class PrintSaleListRequest {

  @JsonProperty("invoiceIds")
  private List<Long> invoiceIds = new ArrayList<Long>();

  @JsonProperty("terminalId")
  private Long terminalId = null;

  @JsonProperty("deviceId")
  private Long deviceId = null;

  @JsonProperty("deviceUn")
  private String deviceUn;

  @JsonProperty("terminalUn")
  private String terminalUn;

  @JsonProperty("printContent")
  private String printContent = null;

  @JsonProperty("supportService")
  private List<String> supportService = Lists.newArrayList();

  @JsonProperty("terminalType")
  private Integer terminalType = null;

  public String getDeviceUn() {
    return deviceUn;
  }

  public void setDeviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
  }

  public String getTerminalUn() {
    return terminalUn;
  }

  public void setTerminalUn(String terminalUn) {
    this.terminalUn = terminalUn;
  }

  @JsonIgnore
  public PrintSaleListRequest invoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
    return this;
  }
  @ApiModelProperty(value = "服务类型")
  public List<String> getSupportService() {
    return supportService;
  }

  public void setSupportService(List<String> supportService) {
    this.supportService = supportService;
  }
  @ApiModelProperty(value = "终端类型")
  public Integer getTerminalType() {
    return terminalType;
  }

  public void setTerminalType(Integer terminalType) {
    this.terminalType = terminalType;
  }

  public PrintSaleListRequest addInvoiceIdsItem(Long invoiceIdsItem) {
    this.invoiceIds.add(invoiceIdsItem);
    return this;
  }

   /**
   * 发票序列号主键列表
   * @return invoiceIds
  **/
  @ApiModelProperty(value = "发票序列号主键列表")
  public List<Long> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }


  @JsonIgnore
  public PrintSaleListRequest terminalId(Long terminalId) {
    this.terminalId = terminalId;
    return this;
  }

   /**
   * 终端id
   * @return terminalId
  **/
  @ApiModelProperty(value = "终端id")
  public Long getTerminalId() {
    return terminalId;
  }

  public void setTerminalId(Long terminalId) {
    this.terminalId = terminalId;
  }

  @JsonIgnore
  public PrintSaleListRequest deviceId(Long deviceId) {
    this.deviceId = deviceId;
    return this;
  }

   /**
   * 设备id
   * @return deviceId
  **/
  @ApiModelProperty(value = "设备id")
  public Long getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(Long deviceId) {
    this.deviceId = deviceId;
  }

  @JsonIgnore
  public PrintSaleListRequest printContent(String printContent) {
    this.printContent = printContent;
    return this;
  }

   /**
   * 打印内容 0-发票带销货清单 1-发票（不含销货清单） 2-销货清单
   * @return printContent
  **/
  @ApiModelProperty(value = "打印内容 0-发票带销货清单 1-发票（不含销货清单） 2-销货清单")
  public String getPrintContent() {
    return printContent;
  }

  public void setPrintContent(String printContent) {
    this.printContent = printContent;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PrintSaleListRequest printSaleListRequest = (PrintSaleListRequest) o;
    return  Objects.equals(this.invoiceIds, printSaleListRequest.invoiceIds) &&
        Objects.equals(this.terminalId, printSaleListRequest.terminalId) &&
        Objects.equals(this.deviceId, printSaleListRequest.deviceId) &&
        Objects.equals(this.printContent, printSaleListRequest.printContent);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceIds, terminalId, deviceId, printContent);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PrintSaleListRequest {\n");

    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    printContent: ").append(toIndentedString(printContent)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
