package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 单据明细列表信息返回
 */
@ApiModel(description = "单据明细列表信息返回")

@JsonInclude(NON_NULL)
public class QueryBillDetailsResult {
  @JsonProperty("total")
  private Long total = null;

  @JsonProperty("list")
  private List<BillItem> list = new ArrayList<BillItem>();

  @JsonIgnore
  public QueryBillDetailsResult total(Long total) {
    this.total = total;
    return this;
  }

   /**
   * 总条数
   * @return total
  **/
  @ApiModelProperty(value = "总条数")
  public Long getTotal() {
    return total;
  }

  public void setTotal(Long total) {
    this.total = total;
  }

  @JsonIgnore
  public QueryBillDetailsResult list(List<BillItem> list) {
    this.list = list;
    return this;
  }

  public QueryBillDetailsResult addListItem(BillItem listItem) {
    this.list.add(listItem);
    return this;
  }

   /**
   * 单据明细列表
   * @return list
  **/
  @ApiModelProperty(value = "单据明细列表")
  public List<BillItem> getList() {
    return list;
  }

  public void setList(List<BillItem> list) {
    this.list = list;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryBillDetailsResult queryBillDetailsResult = (QueryBillDetailsResult) o;
    return Objects.equals(this.total, queryBillDetailsResult.total) &&
        Objects.equals(this.list, queryBillDetailsResult.list);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total, list);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryBillDetailsResult {\n");

    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    list: ").append(toIndentedString(list)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
